<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Catch Themes
 * @subpackage Catch Flames
 */
get_header(); ?>  
          	
			<?php if ( have_posts() ) : ?>
        
                <?php /* Start the Loop */ ?>
                <?php while ( have_posts() ) : the_post(); ?>
                
                    <?php get_template_part( 'content', get_post_format() ); ?>
                
                <?php endwhile; ?>
        
                <?php catchflames_content_nav( 'nav-below' ); ?>
        
            <?php else : ?>
            
                <article id="post-0" class="post no-results not-found">
                    <header class="entry-header">
                        <h1 class="entry-title"><?php _e( 'Nothing Found', 'catch-flames' ); ?></h1>
                    </header><!-- .entry-header -->
            
                    <div class="entry-content">
                        <p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'catch-flames' ); ?></p>
                        <?php get_search_form(); ?>
                    </div><!-- .entry-content -->
                </article><!-- #post-0 -->
            
            <?php endif; ?>
    
        </div><!-- #content -->
        
        <?php 
        /** 
         * catchflames_after_content hook
         */
        do_action( 'catchflames_after_content' ); ?>
        
    </div><!-- #primary -->
    
    <?php 
    /** 
     * catchflames_after_primary hook
     */
    do_action( 'catchflames_after_primary' ); ?>

<?php get_sidebar(); ?>
<?php get_footer(); ?>