<?php
/** Woocommerce Functions & Hook **/

/** Category List widget **/
require get_template_directory() . '/inc/widgets/product-category-list.php';

/** Category product widget **/
require get_template_directory() . '/inc/widgets/product-tab-category.php';

/** Product Slider **/
require get_template_directory() . '/inc/widgets/widget-product-slider.php';

/** Product List **/
require get_template_directory() . '/inc/widgets/widget-product-list.php';

remove_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating',5);
remove_action( 'woocommerce_sidebar','woocommerce_get_sidebar',10 );
remove_action('woocommerce_before_main_content','woocommerce_output_content_wrapper',10);
remove_action('woocommerce_after_main_content','woocommerce_output_content_wrapper_end',10);
remove_action('woocommerce_before_main_content','woocommerce_breadcrumb',20);
add_action('woocommerce_before_main_content','cartbox_woocommerce_wrap_start',22);

function cartbox_woocommerce_wrap_start(){ ?>
    <div class="ws-main-content">
        <div class="tr-container clearfix">
            <div id="primary" class="content-area">
                <main id="main" class="site-main" role="main">
    <?php
}

add_action('woocommerce_after_main_content','cartbox_woocommerce_wrap_end',12);
function cartbox_woocommerce_wrap_end(){
    ?>
                </main>
            </div>
            <?php if(!is_single()){ get_sidebar(); } ?>
        </div>
    </div>
    <?php
}

add_filter( 'woocommerce_add_to_cart_fragments', 'cartbox_woocommerce_header_add_to_cart_fragment' );
function cartbox_woocommerce_header_add_to_cart_fragment( $fragments ) {
    ob_start();
    ?>
    <span class="cart-count"><?php echo absint(WC()->cart->get_cart_contents_count()); ?></span> 
    <?php
    
    $fragments['span.cart-count'] = ob_get_clean();
    
    return $fragments;
}

add_action( 'woocommerce_before_shop_loop_item_title' ,'cartbox_quick_view', 11 );
function cartbox_quick_view(){
?>
    <div class="quick-view-link">
        <?php 
            $product_id = get_the_ID();
            if( function_exists( 'YITH_WCQV' ) ){
                $quick_view = YITH_WCQV_Frontend();
                remove_action( 'woocommerce_after_shop_loop_item', array( $quick_view, 'yith_add_quick_view_button' ), 15 );
                $label = esc_html( get_option( 'yith-wcqv-button-label' ) );
                echo '<a href="#" class="bs-quick-view link-quickview yith-wcqv-button" data-product_id="' . intval( $product_id ) . '">' . esc_html( $label ) . '</a>';
            }
        ?>
    </div>
<?php
} 

remove_action('woocommerce_shop_loop_item_title','woocommerce_template_loop_product_title',10);
add_action('woocommerce_shop_loop_item_title','cartbox_add_link_title',11);
function cartbox_add_link_title(){
        if(get_the_title()){ ?>
            <a href="<?php the_permalink(); ?>"><h2 class="woocommerce-loop-product__title"><?php the_title(); ?></h2></a>
        <?php } 
}

add_action('woocommerce_after_shop_loop_item','cartbox_compare_button',9);
function cartbox_compare_button(){
    if( function_exists( 'YITH_WCWL' ) ){
        $product_id = get_the_ID();
            $url = add_query_arg( 'add_to_wishlist', $product_id );
            ?>
                <a class="wishlist-button" href="<?php echo esc_url($url); ?>">
                    <i class="fa fa-heart" aria-hidden="true"></i>
                </a>
            <?php
          }
}

add_action('woocommerce_after_shop_loop_item_title','cartbox_rating_price_wrap_start',4);
function cartbox_rating_price_wrap_start(){
    ?>
        <div class="price-rating">
    <?php
}

add_action('woocommerce_after_shop_loop_item_title','cartbox_rating_price_wrap_end',11);
function cartbox_rating_price_wrap_end(){
    ?>
        </div>
    <?php
}

add_action('woocommerce_before_single_product_summary','cartbox_wrap_image_saleon_wrap_start',9);
function cartbox_wrap_image_saleon_wrap_start(){
    ?>
        <div class="image-onsale">
    <?php
}
add_action('woocommerce_before_single_product_summary','cartbox_wrap_image_saleon_wrap_end',21);
function cartbox_wrap_image_saleon_wrap_end(){
    ?>
        </div>
    <?php
}


/**
 * WooCommerce advance search function area here
*/
if(!function_exists ('cartbox_adc_product_search_form')){
    function cartbox_adc_product_search_form(){    
        $args = array(
            'number'     => '',
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => true,
        );
        $product_categories = get_terms( 'product_cat', $args ); 
        $categories_show = '<option value="">'.esc_html__('All Categories','cartbox').'</option>';
        $check = '';
        if(is_search()){
            if(isset($_GET['term']) && $_GET['term']!=''){
                $check = sanitize_text_field( wp_unslash( $_GET['term'] ) ); 
            }
        }
        $checked = '';
        foreach($product_categories as $category){
            if(isset( $category->slug )){
                if(trim($category->slug) == trim($check)){
                    $checked = 'selected="selected"';
                }
                $categories_show  .= '<option '.$checked.' data-tokens="'.esc_attr( $category->slug ).'"  value="'.esc_attr( $category->slug ).'">'.esc_html( $category->name ).'</option>';
                $checked = '';
            }
        }      
        
        $form = '<div class="header-search cartbox_adc_search">
                    <div class="header-search_form">
                        <form class="product-search form-inline" role="search" method="get" id="searchform" action="' . esc_url( home_url( '/'  ) ) . '">
                            <div class="header-search_filter">
                                <select class="formDropdown" name="term">'.$categories_show.'</select>
                                <i class="fa fa-angle-down customColor"></i>
                            </div>
                            <button type="submit" class="product-search">
                                <i class="fa fa-search"></i>
                            </button>
                            <input type="hidden" name="post_type" value="product" />
                            <input type="hidden" name="taxonomy" value="product_cat" />
                        </form>
                    </div>
                </div>';  
        echo $form;       
    }
}

