<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package cartbox
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<?php
        $cartbox_post_image = wp_get_attachment_image_src(get_post_thumbnail_id(),'cartbox-single-page');
        if($cartbox_post_image){
            ?><img src="<?php echo esc_url($cartbox_post_image[0]) ?>" alt="<?php the_title_attribute()?>" title="<?php the_title_attribute()?>" /><?php
        }
     ?>
    
    <header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php
				cartbox_posted_on();
				cartbox_posted_by();
			?>
		</div><!-- .entry-meta -->
		<?php
		endif; ?>
	</header><!-- .entry-header -->
    
	<div class="entry-content">
		<?php
			if ( is_singular() ) :
                the_content();
            else:
                the_excerpt();
            endif;

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'cartbox' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php cartbox_entry_footer(); ?>
	</footer><!-- .entry-footer -->
    
</article><!-- #post-<?php the_ID(); ?> -->
