<?php
/**
 * Define fields for Widgets.
 * 
 * @package cartbox
 */

function cartbox_widgets_show_widget_field( $instance = '', $widget_field = '', $athm_field_value = '' ) {
	
    $cartbox_pagelist[0] = array(
        'value' => 0,
        'label' => esc_html__('--choose--','cartbox')
    );
    
    $arg = array('posts_per_page'   => -1);
    $cartbox_pages = get_pages($arg);
    foreach($cartbox_pages as $cartbox_page) :
        $cartbox_pagelist[$cartbox_page->ID] = array(
            'value' => $cartbox_page->ID,
            'label' => $cartbox_page->post_title
        );
    endforeach;
    
	extract( $widget_field );
	
	switch( $cartbox_widgets_field_type ) {
	
		// Standard text field
		case 'text' : ?>
			<p>
				<label for="<?php echo esc_attr($instance->get_field_id( $cartbox_widgets_name )); ?>"><?php echo esc_html($cartbox_widgets_title); ?>:</label>
				<input class="widefat" id="<?php echo esc_attr($instance->get_field_id( $cartbox_widgets_name )); ?>" name="<?php echo esc_attr($instance->get_field_name( $cartbox_widgets_name )); ?>" type="text" value="<?php echo esc_html($athm_field_value); ?>" />
				
				<?php if( isset( $cartbox_widgets_description ) ) { ?>
				<br />
				<small><?php echo esc_html($cartbox_widgets_description); ?></small>
				<?php } ?>
			</p>
			<?php
			break;

		//Multi checkboxes
        case 'multicheckboxes' :
            
            if( isset( $cartbox_widgets_title ) ) { ?>
                <label><?php echo esc_html( $cartbox_widgets_title ); ?>:</label>
            <?php }
            echo '<div class="cartbox-checkbox">';
                foreach ( $cartbox_widgets_field_options as $athm_option_name => $athm_option_title) {
                    if( isset( $athm_field_value[$athm_option_name] ) ) {
                        $athm_field_value[$athm_option_name] = 1;
                    }else{
                        $athm_field_value[$athm_option_name] = 0;
                    }                
                ?>
                    <p>
                        <input id="<?php echo esc_attr( $instance->get_field_id( $cartbox_widgets_name ) ); ?>" name="<?php echo esc_attr( $instance->get_field_name( $cartbox_widgets_name ) ).'['.esc_attr( $athm_option_name ).']'; ?>" type="checkbox" value="1" <?php checked('1', $athm_field_value[$athm_option_name]); ?>/>
                        <label for="<?php echo esc_attr( $instance->get_field_id( $athm_option_name ) ); ?>"><?php echo esc_html( $athm_option_title ); ?></label>
                    </p>
                <?php
                    }
            echo '</div>';
                if (isset($cartbox_one_widgets_description)) {
            ?>
                    <small><em><?php echo esc_html($cartbox_one_widgets_description); ?></em></small>
            <?php
                }
            
        break;
            
		// Select field
		case 'select' : ?>
			<p>
				<label for="<?php echo esc_attr($instance->get_field_id( $cartbox_widgets_name )); ?>"><?php echo esc_html($cartbox_widgets_title); ?>:</label>
				<select name="<?php echo esc_attr($instance->get_field_name( $cartbox_widgets_name )); ?>" id="<?php echo esc_attr($instance->get_field_id( $cartbox_widgets_name )); ?>" class="widefat">
					<?php
					foreach ( $cartbox_widgets_field_options as $athm_option_name => $athm_option_title ) { ?>
						<option value="<?php echo esc_html($athm_option_name); ?>" id="<?php echo esc_attr($instance->get_field_id( $athm_option_name )); ?>" <?php selected( $athm_option_name, $athm_field_value ); ?>><?php echo esc_html($athm_option_title); ?></option>
					<?php } ?>
				</select>

				<?php if( isset( $cartbox_widgets_description ) ) { ?>
				<br />
				<small><?php echo esc_html($cartbox_widgets_description); ?></small>
				<?php } ?>
			</p>
			<?php
        break;
            
        case 'upload' :

            $output = '';
            $id = esc_attr($instance->get_field_id($cartbox_widgets_name));
            $class = '';
            $int = '';
            $value = esc_html($athm_field_value);
            $name = esc_attr($instance->get_field_name($cartbox_widgets_name));


            if ($value) {
                $class = ' has-file';
            }
            $output .= '<div class="sub-option widget-upload">';
            $output .= '<label for="' . esc_attr($instance->get_field_id($cartbox_widgets_name)) . '">' . esc_html($cartbox_widgets_title) . '</label><br/>';
            $output .= '<input id="' . $id . '" class="upload' . esc_attr($class). '" type="text" name="' . $name . '" value="' . $value . '" placeholder="' . esc_attr__('No file chosen', 'cartbox') . '" />' . "\n";
            if (function_exists('wp_enqueue_media')) {
                
                    $output .= '<input id="upload-' . $id . '" class="upload-button button" type="button" value="' . esc_attr__('Upload', 'cartbox') . '" />' . "\n";

            } else {
                $output .= '<p><i>' . esc_html__('Upgrade your version of WordPress for full media support.', 'cartbox') . '</i></p>';
            }

            $output .= '<div class="screenshot team-thumb" id="' . $id . '-image">' . "\n";

            if ($value != '') {
                $remove = '<a class="remove-image remove-screenshot">'.esc_html__('Remove','cartbox').'</a>';
                $attachment_id = attachment_url_to_postid($value);

                $image_array = wp_get_attachment_image_src($attachment_id, 'medium');
                $image = preg_match('/(^.*\.jpg|jpeg|png|gif|ico*)/i', $value);
                if ($image) {
                    $output .= '<img src="' . esc_url($image_array[0]) . '" alt="" />' . $remove;
                } else {
                    $parts = explode("/", $value);
                    for ($i = 0; $i < sizeof($parts); ++$i) {
                        $title = $parts[$i];
                    }

                    // No output preview if it's not an image.
                    $output .= '';

                    // Standard generic output if it's not an image.
                    $title = esc_html__('View File', 'cartbox');
                    $output .= '<div class="no-image"><span class="file_link"><a href="' . $value . '" target="_blank" rel="external">' . $title . '</a></span></div>';
                }
            }
            $output .= '</div></div>' . "\n";
            echo $output;
            break;
	}
	
}

function cartbox_widgets_updated_field_value( $widget_field, $new_field_value ) {
    
	extract( $widget_field );
	
	// Allow only integers in number fields
	if( $cartbox_widgets_field_type == 'number' ) {
		return absint( $new_field_value );
	}
    elseif ($cartbox_widgets_field_type == 'multicheckboxes') {
         return wp_kses_post($new_field_value);
    } 
    elseif( $cartbox_widgets_field_type == 'textarea' ) {
        
		return  wp_kses_post( force_balance_tags( $cartbox_widgets_field_type ) );
		
	}
    else {
		return sanitize_text_field( $new_field_value );
	}

}