<?php
/**
 * @package cartbox
 */

add_action('widgets_init', 'cartbox_testimonial_register');

function cartbox_testimonial_register() {
    register_widget('cartbox_testimonial_Widget');
}

class cartbox_testimonial_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
                'cartbox_testimonial_Widget', esc_html__('CartBox : Testimonial', 'cartbox'), array(
                'description' => esc_html__('This Widget show Testimonial', 'cartbox')
                )
        );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {
        $cartbox_category_lists = cartbox_category_lists();
        $fields = array(
            'testimonial_title' => array(
                'cartbox_widgets_name' => 'testimonial_title',
                'cartbox_widgets_title' => esc_html__('Title', 'cartbox'),
                'cartbox_widgets_field_type' => 'text',
            ),
            'testimonial_category' => array(
                'cartbox_widgets_name' => 'testimonial_category',
                'cartbox_widgets_title' => esc_html__('Blog Category', 'cartbox'),
                'cartbox_widgets_field_type' => 'select',
                'cartbox_widgets_field_options' => $cartbox_category_lists,
            ),
            'testimonial_bg_image' => array(
                'cartbox_widgets_name' => 'testimonial_bg_image',
                'cartbox_widgets_title' => esc_html__('Background Image', 'cartbox'),
                'cartbox_widgets_field_type' => 'upload',
            ),
        );

        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {
        extract($args);

        $title_widget = apply_filters( 'widget_title', empty( $instance['testimonial_title'] ) ? '' : $instance['testimonial_title'], $instance, $this->id_base );
        $testimonial_category = isset( $instance['testimonial_category'] ) ? $instance['testimonial_category'] : '' ;
        $testimonial_bg_image = isset( $instance['testimonial_bg_image'] ) ? $instance['testimonial_bg_image'] : '' ;

        echo $before_widget;
        if($testimonial_category){
        ?>
            <div <?php if($testimonial_bg_image){ ?> style="background: url(<?php echo esc_url($testimonial_bg_image); ?>); " <?php } ?> class="blog-wrap">
                <div class="tr-container">
                    <div class="testimonial-contents">
                        <?php
                        $blog_args = array(
                            'poat_type' => 'post',
                            'order' => 'DESC',
                            'posts_per_page' => 6,
                            'post_status' => 'publish',
                            'category_name' => $testimonial_category
                        );
                        $blog_query = new WP_Query($blog_args);
                        
                        if (!empty($title_widget)): ?>
                        
                            <div class="section-title  wow fadeInUp">
                                <?php echo $args['before_title'] . esc_html($title_widget) . $args['after_title']; ?>
                            </div>
                        
                        <?php endif;

                        if($blog_query->have_posts()): ?>
                            <div class="testimonial-main-wrap">
                                <div class="cartbox-testimonial wow fadeInUp">
                                    <?php while($blog_query->have_posts()){
                                            $blog_query->the_post();
                                            $blog_image = wp_get_attachment_image_src(get_post_thumbnail_id(),'cartbox-testimonial-image');
                                            ?>
                                                <div class="testimonial-image-wrap">
                                                
                                                    <?php if($blog_image[0]){ ?>
                                                        <div class="image-testimonial">
                                                            <a href="<?php the_permalink(); ?>"><img alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" src="<?php echo esc_url($blog_image[0]); ?>" /></a>
                                                        </div>
                                                    <?php } ?>

                                                    <div class="testimonial-content">
                                                        <?php if(get_the_content() || get_the_title()){ ?>
                                                            <div class="testimonial-content-title">

                                                                <?php if(get_the_content()){ ?>
                                                                    <p><?php the_excerpt(); ?></p>
                                                                <?php } ?>

                                                                <?php if(get_the_title()){ ?>
                                                                    <a href="<?php the_permalink(); ?>">
                                                                        <h3><?php the_title(); ?></h3>
                                                                    </a>
                                                                <?php } ?>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                    
                                                </div>
                                            <?php
                                    } ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        }
        echo $after_widget;
    }

    public function update($new_instance, $old_instance) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        foreach ($widget_fields as $widget_field) {

            extract($widget_field);

            $instance[$cartbox_widgets_name] = cartbox_widgets_updated_field_value($widget_field, $new_instance[$cartbox_widgets_name]);
        }

        return $instance;
    }

    public function form($instance) {
        $widget_fields = $this->widget_fields();

        foreach ($widget_fields as $widget_field) {

            extract($widget_field);
            $cartbox_widgets_field_value = !empty($instance[$cartbox_widgets_name]) ? esc_attr($instance[$cartbox_widgets_name]) : '';
            cartbox_widgets_show_widget_field($this, $widget_field, $cartbox_widgets_field_value);
        }
    }

}
