<?php
/**
 * @package cartbox
 */

add_action('widgets_init', 'cartbox_product_slide_register');

function cartbox_product_slide_register() {
    register_widget('cartbox_product_slider_Widget');
}

class cartbox_product_slider_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
                'cartbox_product_slider_Widget', esc_html__('CartBox : Product Slide', 'cartbox'), array(
                'description' => esc_html__('This Widget show product on carouser slider For Slider Category', 'cartbox')
                )
        );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {
        $cartbox_Product_Category_list = cartbox_product_cat_list();
        $fields = array(
                'slider_title' => array(
                'cartbox_widgets_name' => 'slider_title',
                'cartbox_widgets_title' => esc_html__('Title', 'cartbox'),
                'cartbox_widgets_field_type' => 'text',
            ),
            'product_category' => array(
                'cartbox_widgets_name' => 'product_category',
                'cartbox_widgets_title' => esc_html__('Product Category', 'cartbox'),
                'cartbox_widgets_field_type' => 'select',
                'cartbox_widgets_field_options' => $cartbox_Product_Category_list,
            ),
        );

        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {
        extract($args);
        
        $title_widget = apply_filters( 'widget_title', empty( $instance['slider_title'] ) ? '' : $instance['slider_title'], $instance, $this->id_base );
        $product_category = isset( $instance['product_category'] ) ? $instance['product_category'] : '' ;
        
        echo $before_widget;
        ?>
            <div class="product-slider-wrap">
                <div class="tr-container">
                
                    <?php if($title_widget){ ?>
                        <div class="section-title wow fadeInUp">
                            <?php echo $args['before_title'] . esc_html($title_widget) . $args['after_title']; ?>
                        </div>
                    <?php } ?>
                    
                    <?php if($product_category){ 
                    
                        $product_query = new WP_Query(
                            array(
                                'post_type' => 'product',
                                'tax_query' => array(array('taxonomy'  => 'product_cat',
                                                   'field'     => 'slug', 
                                                   'terms'     => $product_category                                                                 
                                                )),
                                'posts_per_page' => -1
                            )
                        );
                        
                        if($product_query->have_posts()): ?>
                            <ul class="products wrap-pro-slider wow fadeInUp">
                            
                                <?php while($product_query->have_posts()){
                                    $product_query->the_post();
                                    global $product;
                                    wc_get_template_part( 'content', 'product' );
                                } ?>
                                
                            </ul>
                        <?php endif; ?>
                        
                    <?php } ?>
                </div>
            </div>
        <?php
        echo $after_widget;
    }

    public function update($new_instance, $old_instance) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        foreach ($widget_fields as $widget_field) {

            extract($widget_field);

            $instance[$cartbox_widgets_name] = cartbox_widgets_updated_field_value($widget_field, $new_instance[$cartbox_widgets_name]);
        }

        return $instance;
    }

    public function form($instance) {
        $widget_fields = $this->widget_fields();

        foreach ($widget_fields as $widget_field) {

            extract($widget_field);
            $cartbox_widgets_field_value = !empty($instance[$cartbox_widgets_name]) ? esc_attr($instance[$cartbox_widgets_name]) : '';
            cartbox_widgets_show_widget_field($this, $widget_field, $cartbox_widgets_field_value);
        }
    }

}
