<?php
/**
 * @package cartbox
 */

add_action('widgets_init', 'cartbox_blog_register');

function cartbox_blog_register() {
    register_widget('cartbox_blog_Widget');
}

class cartbox_blog_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
                'cartbox_blog_Widget',esc_html__( 'CartBox : Blog', 'cartbox'), array(
                'description' => esc_html__('This Widget show Blogs', 'cartbox')
                )
        );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {
        $cartbox_category_lists = cartbox_category_lists();
        $fields = array(
            'blog_title' => array(
                'cartbox_widgets_name' => 'blog_title',
                'cartbox_widgets_title' => esc_html__('Title', 'cartbox'),
                'cartbox_widgets_field_type' => 'text',
            ),
            'blog_category' => array(
                'cartbox_widgets_name' => 'blog_category',
                'cartbox_widgets_title' => esc_html__('Blog Category', 'cartbox'),
                'cartbox_widgets_field_type' => 'select',
                'cartbox_widgets_field_options' => $cartbox_category_lists,
            ),
        );

        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {
        extract($args);
        
        $title_widget = apply_filters( 'widget_title', empty( $instance['blog_title'] ) ? '' : $instance['blog_title'], $instance, $this->id_base );        
        $blog_category = isset( $instance['blog_category'] ) ? $instance['blog_category'] : '' ;        
        echo $before_widget;
        ?>
            <div class="blog-wrap">
                <div class="tr-container">
                    <div class="blog-contents">
                        <?php
                        $blog_args = array(
                            'poat_type' => 'post',
                            'order' => 'DESC',
                            'posts_per_page' => 6,
                            'post_status' => 'publish',
                            'category_name' => $blog_category
                        ); 
                        $blog_query = new WP_Query($blog_args);
                        
                        if (!empty($title_widget)): ?>
                        
                            <div class="section-title  wow fadeInUp">
                                <?php echo $args['before_title'] . esc_html($title_widget) . $args['after_title']; ?>
                            </div>
                        
                        <?php endif;
                        
                        if($blog_query->have_posts()): ?>
                            <div class="blog-main-wrap">
                                <div class="blog-loop-wrap wow fadeInUp">
                                    <?php while($blog_query->have_posts()){
                                            $blog_query->the_post();
                                            $blog_image = wp_get_attachment_image_src(get_post_thumbnail_id(),'cartbox-blog-image');
                                            ?>
                                                <div class="bs-loop-blog">
                                                
                                                    <?php if($blog_image[0]){ ?>
                                                        <div class="image-blog">
                                                            <a href="<?php the_permalink(); ?>">
                                                                <img alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" src="<?php echo esc_url($blog_image[0]); ?>" />
                                                            </a>
                                                        </div>
                                                    <?php } ?>
                                                    
                                                    <div class="date-content">
                                                    
                                                        <div class="date-blog">
                                                            <span class="date"><?php echo esc_html(get_the_date(get_option('date_format'))); ?></span>
                                                        </div>
                                                        
                                                        <?php if(get_the_content() || get_the_title()){ ?>
                                                            <div class="blog-content-title">
                                                            
                                                                <?php if(get_the_title()){ ?>
                                                                    <a href="<?php the_permalink(); ?>">
                                                                        <h3><?php the_title(); ?></h3>
                                                                    </a>
                                                                <?php } ?>
                                                                
                                                            </div>
                                                        <?php } ?>
                                                        
                                                        <a class="btn-readmore" href="<?php the_permalink(); ?>">
                                                            <?php esc_html_e('Read More', 'cartbox'); ?>
                                                        </a>
                                                    </div>
                                                    
                                                </div>
                                            <?php
                                    } ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        echo $after_widget;
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param	array	$new_instance	Values just sent to be saved.
     * @param	array	$old_instance	Previously saved values from database.
     *
     * @uses	cartbox_widgets_updated_field_value()		defined in widget-fields.php
     *
     * @return	array Updated safe values to be saved.
     */
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ($widget_fields as $widget_field) {

            extract($widget_field);

            // Use helper function to get updated field values
            $instance[$cartbox_widgets_name] = cartbox_widgets_updated_field_value($widget_field, $new_instance[$cartbox_widgets_name]);
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param	array $instance Previously saved values from database.
     *
     * @uses	cartbox_widgets_show_widget_field()		defined in widget-fields.php
     */
    public function form($instance) {
        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ($widget_fields as $widget_field) {

            // Make array elements available as variables
            extract($widget_field);
            $cartbox_widgets_field_value = !empty($instance[$cartbox_widgets_name]) ? esc_attr($instance[$cartbox_widgets_name]) : '';
            cartbox_widgets_show_widget_field($this, $widget_field, $cartbox_widgets_field_value);
        }
    }

}
