<?php

/** cartbox Category List**/
function cartbox_category_lists(){
  $category 	=	get_categories();
  $cat_list 	=	array();
  $cat_list[0]=	esc_html__('Select category','cartbox');
  foreach ($category as $cat) {
     $cat_list[$cat->slug]	=	$cat->name;
  }
 return $cat_list;
}

/** cartbox Posts List **/
function cartbox_post_list(){
    $options_posts = array();
    $options_posts_obj = get_posts('posts_per_page=-1');
    $options_posts[''] = esc_html__('Select a Post:','cartbox');
    foreach ($options_posts_obj as $post) {
        $options_posts[$post->ID] = $post->post_title;
    }
    return $options_posts;
}

function cartbox_product_cat_list($args = array()){
    $args = wp_parse_args( $args, array(
                 'taxonomy'     => 'product_cat',
                 'orderby'      => 'name',
                 'show_count'   => 0,
                 'pad_counts'   => 0,
         ) );
    $cartbox_pro_cat_lists = get_categories( $args );
    $cartbox_pro_cat_array = array();
    $cartbox_pro_cat_array[''] = esc_html__('--Choose--','cartbox');
    foreach($cartbox_pro_cat_lists as $cartbox_pro_cat_list){
        $cartbox_pro_cat_array[$cartbox_pro_cat_list->slug] = $cartbox_pro_cat_list->name;
    }
    return $cartbox_pro_cat_array;
}



/** Slider Function **/
function cartbox_slider_callback(){
    $cartbox_home_slider_category = esc_attr(get_theme_mod('cartbox_home_slider_category'));
    if($cartbox_home_slider_category){
        $slider_query = new WP_Query(array('post_type'=>'post','order' => 'DESC','posts_per_page' => -1,'post_status' => 'publish','category_name' => $cartbox_home_slider_category));
        if($slider_query->have_posts()):
            ?>
                <div class="banner-slider">
                    <div class="main-slider-wraper">
                        <div id="cartbox-slider-wrap">
                            <?php
                            while($slider_query->have_posts()):
                                $slider_query->the_post();
                                $slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(),'cartbox-slider-image');
                                ?>
                                    <div class="row-slider">
                                        <div class="content-slider">
                                            <?php if($slider_image[0]){ ?>
                                                <div class="image-slider">
                                                    <img alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>" src="<?php echo esc_url($slider_image[0]); ?>" />
                                                </div>
                                                <?php } ?>
                                               <div class="slider-caption"> 
                                                    <h2 class="titl-slider">
                                                      <?php the_title();?>
                                                    </h2> 
                                                    
                                                    <div class="slider-desc">
                                                        <?php the_content(); ?>
                                                    </div>
                                                    
                                              </div>
                                        </div>
                                    </div>
                                <?php
                            endwhile;
                            ?>
                        </div>
                    </div>
                </div>    
            <?php
        endif;
    }
}
add_action('cartbox_slider_callback_action','cartbox_slider_callback');

function cartbox_header_search(){
    $cartbox_header_search_section = get_theme_mod('cartbox_header_search_section','show');
    if($cartbox_header_search_section == 'show' || $cartbox_header_search_section == ''){
        if(cartbox_is_woocommerce_activated()){ ?>
            <div class="advance-search">
                <?php cartbox_product_search(); ?>
            </div>
        <?php }
    } ?>
<?php
}
add_action('cartbox_header_search_action','cartbox_header_search');

/** Header Product Search **/
function cartbox_product_search(){
    if ( cartbox_is_woocommerce_activated() ) { ?>
        <div class="custom-product-search">
            <form class="search-product-cat" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <?php $cats = cartbox_get_product_categories();
                if($cats){ ?> 
                    <div class="cat-list">      
                        <?php
                            echo cartbox_product_cat_select('indent_sub');
                        ?>
                    </div>
                <?php } ?>
                <div class="search-field">
                    <input type="hidden" name="post_type" value="product" />
                    <input name="s" type="text" value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php esc_attr_e( 'Enter Your Key Word...', 'cartbox' ); ?>"/>
                </div>
                 <div class="search-icon">
                    <button type="submit"><i class="fa fa-search"></i></button>
                </div>
            </form>
        </div>
        <?php
    }
}
add_action('cartbox_header_product_search_action','cartbox_product_search');
function cartbox_product_cat_select( $indent_sub = '', $select_id = 'product_cat_list' ) {

    $cats = cartbox_get_product_categories();
    
    $select = '';

    if ( count( $cats ) > 0 ) {

        $select = '<select class="cartbox-cat-list" id="' . $select_id .'" name="product_cat">';
        $select .= apply_filters('cartbox_cat_all_option', '<option value="">'. esc_html__( 'All Category', 'cartbox' ) .'</option>' );

        foreach( $cats as $cat ) {

            if ($indent_sub === 'indent_sub' ) {

                if ( $cat->parent === 0 ) {

                    $select .= sprintf( '<option value="%s">%s</option>', esc_attr( $cat->category_nicename ), esc_html( $cat->name ) );

                    /**
                     * Start child
                     */
                    $children = cartbox_get_product_categories(array('parent' => $cat->term_id ));

                    if ( count($children) ) {

                        foreach( $children as $ct ) {
                            $select .= sprintf( '<option value="%s">&nbsp&nbsp%s</option>', esc_attr( $ct->category_nicename ), esc_html( $ct->name ) );
                        }
                    }
                }


            } else {

                $select .= sprintf( '<option value="%s" %s>%s</option>', esc_attr( $cat->category_nicename ), cartbox_cat_selected($cat->category_nicename), esc_html( $cat->name ) );

            }

        }

        $select .= '</select>';

    }

    return $select;
    
}
function cartbox_get_product_categories( $args = array() ) {
    $args = wp_parse_args( $args, array(
                 'taxonomy'     => 'product_cat',
                 'orderby'      => 'name',
                 'show_count'   => 0,
                 'pad_counts'   => 0,
         ) );

    return get_categories( $args );
}



function cartbox_cat_selected( $cat_nicename ) {
    $q_var = get_query_var( 'product_cat' );

    if ( $q_var === $cat_nicename ) {

        return 'selected="selected"';
    }

    return false;
}

// function to add social icons
function cartbox_social_link(){
        $facebooklink =  get_theme_mod('cartbox_facebook_text');
        $twitterlink =  get_theme_mod('cartbox_twitter_text');
        $google_pluslink =  get_theme_mod('cartbox_googleplus_text');
        $youtubelink = get_theme_mod('cartbox_youtube_text');
        $pinterestlink = get_theme_mod('cartbox_pinterest_text');
        $linkedinlink = get_theme_mod('cartbox_linkedin_text');
        $instagramlink =  get_theme_mod('cartbox_instagram_text');
      ?>
        <div class="social-icons ">
            <?php if(!empty($facebooklink)){?>
                <a href="<?php echo esc_url($facebooklink); ?>" class="facebook" target="_blank"><i class="fa fa-facebook"></i><span></span></a>
                <?php } ?>
                
            <?php if(!empty($twitterlink)){?>
            <a href="<?php echo esc_url($twitterlink); ?>" class="twitter" target="_blank"><i class="fa fa-twitter"></i><span></span></a>
            <?php } ?>

            <?php if(!empty($google_pluslink)){?>
            <a href="<?php echo esc_url($google_pluslink); ?>" class="gplus" target="_blank"><i class="fa fa-google-plus"></i><span></span></a>
            <?php } ?>

            <?php if(!empty($youtubelink)){ ?>
            <a href="<?php echo esc_url($youtubelink); ?>" class="youtube" target="_blank"><i class="fa fa-youtube"></i><span></span></a>
            <?php } ?>

            <?php if(!empty($pinterestlink)){ ?>
            <a href="<?php echo esc_url($pinterestlink); ?>" class="pinterest"  target="_blank"><i class="fa fa-pinterest"></i><span></span></a>
            <?php } ?>

            <?php if(!empty($linkedinlink)){ ?>
            <a href="<?php echo esc_url($linkedinlink); ?>" class="linkedin"target="_blank"><i class="fa fa-linkedin"></i><span></span></a>
            <?php } ?>

            <?php if(!empty($instagramlink)){ ?>
            <a href="<?php echo esc_url($instagramlink); ?>" class="instagram" target="_blank"><i class="fa fa-instagram"></i><span></span></a>
            <?php } ?>

        </div>
        <?php
}
add_action('cartbox_social_link_action','cartbox_social_link');

/**  Check Woocomerce Activation  **/
if ( ! function_exists( 'cartbox_is_woocommerce_activated' ) ) {

    function cartbox_is_woocommerce_activated() {
        return class_exists( 'woocommerce' ) ? true : false;
    }
}
function cartbox_sanitize_bradcrumb($input){
    $all_tags = array(
        'a'=>array(
            'href'=>array()
        )
     );
    return wp_kses($input,$all_tags);
    
}
//cartbox breadcrumbs settingg
 if ( ! function_exists( 'cartbox_breadcrumbs' ) ) :
    function cartbox_breadcrumbs() {
        global $post;
        $showOnHome = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
    
        $delimiter = '&#10142;';
    
        $showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
        $homeLink = esc_url( home_url() );
    
        if (is_home() || is_front_page()) {
    
            if ($showOnHome == 1)
                echo '<div id="the-cartbox-breadcrumb"><a href="' . $homeLink . '">' . esc_html__('Home', 'cartbox') . '</a></div></div>';
        } else {
    
            echo '<div id="the-cartbox-breadcrumb"><a href="' . $homeLink . '">' . esc_html__('Home', 'cartbox') . '</a> <i class="fa fa-long-arrow-right" aria-hidden="true"></i> ';
    
            if (is_category()) {
                $thisCat = get_category(get_query_var('cat'), false);
                if ($thisCat->parent != 0)
    
                    echo esc_html(get_category_parents(esc_attr($thisCat->parent), TRUE, ' ' . esc_html($delimiter) . ' '));
                echo '<span class="current">' . esc_html__('Archive By Category','cartbox').' "' . esc_attr(single_cat_title('', false)) . '"</span>';
            } elseif (is_search()) {
                echo '<span class="current">' . esc_html__('Search results for','cartbox'). '"' . get_search_query() . '"' . '</span>';
            } elseif (is_day()) {
                echo '<a href="' . esc_url(get_year_link(esc_attr(get_the_time('Y')))) . '">' . esc_html(get_the_time('Y')) . '</a> ' . esc_html($delimiter) . ' ';
                echo '<a href="' . esc_url(get_month_link(esc_attr(get_the_time('Y')), esc_attr(get_the_time('m')))) . '">' . esc_html(get_the_time('F')) . '</a> ' . esc_html($delimiter) . ' ';
                echo '<span class="current">' . esc_attr(get_the_time('d')) . '</span>';
            } elseif (is_month()) {
                echo '<a href="' . esc_url(get_year_link(esc_attr(get_the_time('Y')))) . '">' . esc_html(get_the_time('Y')) . '</a> ' . esc_html($delimiter) . ' ';
                echo '<span class="current">' . esc_html(get_the_time('F')) . '</span>';
            } elseif (is_year()) {
                echo '<span class="current">' . esc_html(get_the_time('Y')) . '</span>';
            } elseif (is_single() && !is_attachment()) {
                if (get_post_type() != 'post') {
                    $post_type = get_post_type_object(get_post_type());
                    $slug = $post_type->rewrite;
                    echo '<a href="' . esc_url($homeLink) . '/' . esc_attr($slug['slug']) . '/">' . esc_html($post_type->labels->singular_name) . '</a>';
                    if ($showCurrent == 1)
                        echo ' ' . esc_html($delimiter) . ' ' . '<span class="current">' . esc_html(get_the_title()) . '</span>';
                } else {
                    $cat = get_the_category();
                    $cat = $cat[0];
                    $cats = get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
                    if ($showCurrent == 0)
                        $cats = preg_replace("#^(.+)\s$delimiter\s$#", "$1", $cats);
                    echo cartbox_sanitize_bradcrumb($cats);
                    if ($showCurrent == 1)
                        echo '<span class="current">' . esc_html(get_the_title()) . '</span>';
                }
            } elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
                $post_type = get_post_type_object(get_post_type());
                if($post_type){
                echo '<span class="current">' . esc_html($post_type->labels->singular_name) . '</span>';
                }
            } elseif (is_attachment()) {
                if ($showCurrent == 1) echo ' ' . '<span class="current">' . esc_html(get_the_title()) . '</span>';
            } elseif (is_page() && !$post->post_parent) {
                if ($showCurrent == 1)
                    echo '<span class="current">' . esc_html(get_the_title()) . '</span>';
            } elseif (is_page() && $post->post_parent) {
                $parent_id = $post->post_parent;
                $breadcrumbs = array();
                while ($parent_id) {
                    $page = get_page($parent_id);
                    $breadcrumbs[] = '<a href="' . esc_url(get_permalink($page->ID)) . '">' . esc_html(get_the_title($page->ID)) . '</a>';
                    $parent_id = $page->post_parent;
                }
                $breadcrumbs = array_reverse($breadcrumbs);
                for ($i = 0; $i < count($breadcrumbs); $i++) {
                    echo cartbox_sanitize_bradcrumb($breadcrumbs[$i]);
                    if ($i != count($breadcrumbs) - 1)
                        echo ' ' . esc_html($delimiter). ' ';
                }
                if ($showCurrent == 1)
                    echo ' ' . esc_html($delimiter) . ' ' . '<span class="current">' . esc_html(get_the_title()) . '</span>';
            } elseif (is_tag()) {
                echo '<span class="current">' . esc_html__('Posts tagged','cartbox').' "' . esc_html(single_tag_title('', false)) . '"' . '</span>';
            } elseif (is_author()) {
                global $author;
                $userdata = get_userdata($author);
                echo '<span class="current">' . esc_html__('Articles posted by ','cartbox'). esc_html($userdata->display_name) . '</span>';
            } elseif (is_404()) {
                echo '<span class="current">' . esc_html__('Error 404','cartbox') . '</span>';
            }
    
            if (get_query_var('paged')) {
                if (is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author())
                    echo ' (';
                echo esc_html__('Page', 'cartbox') . ' ' . get_query_var('paged');
                if (is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author())
                    echo ')';
            }
    
            echo '</div>';
        }
    }
endif;


 if ( ! function_exists( 'cartbox_page_title' ) ) :
    function cartbox_page_title(){
    ?>
        <header class="page-header">
                <div class="header-banner" data-stellar-background-ratio="0.5" style="background-image: url('<?php echo esc_url(get_theme_mod('cartbox_page_bg_image','')); ?>');">
                <div class="banner-title">
                        <?php
                  if(is_archive()) {
                    the_archive_title( '<h1 class="page-title">', '</h1>' );
                    the_archive_description( '<div class="taxonomy-description">', '</div>' );
                  } elseif(is_single() || is_singular('page')) {
                    wp_reset_postdata();
                    the_title('<h1 class="page-title">', '</h1>');
                  } elseif(is_search()) {
                                ?>
                                <h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'cartbox' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
                                <?php
                            } elseif(is_404()) {
                                ?>
                                <h1 class="page-title"><?php esc_html_e( '404 Error', 'cartbox' ); ?></h1>
                                <?php
                            }
                ?>
                        <?php cartbox_breadcrumbs(); ?>
                    </div>
                </div>
        </header>
    <?php
    }
endif;
add_action('cartbox_title','cartbox_page_title');


