<?php
/**
 * cartbox Theme Customizer Custom
 *
 * @package cartbox
 */
/**
 * Add new options the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function cartbox_custom_customize_register( $wp_customize ) {

    $cartbox_category_lists =	cartbox_category_lists();
    $posts_list = cartbox_post_list();
    
    // the-multiple sanitizer
    require get_template_directory() . '/inc/cartbox-sanitizer.php';
    
	// Default Setting And Options
    $wp_customize->add_panel('cartbox_default_setups',array(
    	'priority' => '1',
    	'capability' => 'edit_theme_options',
    	'theme_supports' => '',
    	'title' => esc_html__('Default Setups','cartbox'),
	));	

	//Add Default Sections to General Panel
	$wp_customize->get_section('title_tagline')->panel = 'cartbox_default_setups'; //priority 20
	$wp_customize->get_section('colors')->panel = 'cartbox_default_setups'; //priority 40
	$wp_customize->get_section('header_image')->panel = 'cartbox_default_setups'; //priority 60
	$wp_customize->get_section('background_image')->panel = 'cartbox_default_setups'; //priority 80
	$wp_customize->get_section('static_front_page')->panel = 'cartbox_default_setups'; //priority 120

    $wp_customize->add_section('cartbox_top_header_cart',array(
        'priority' => '10',
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => esc_html__('Show Header Menu Cart','cartbox'),
        'description' => esc_html__('Manage Header Menu Cart','cartbox'),
        'panel' => 'cartbox_default_setups'
    ));
    
    //Enable/Disable Search
    $wp_customize->add_setting('cartbox_general_cart_top_header',
    array(
        'default'           =>  'no',
        'sanitize_callback' =>  'cartbox_sanitize_yes_no',
        )
    );
    $wp_customize->add_control('cartbox_general_cart_top_header',array(
        'description'   =>  esc_html__('Enable/Disable This Section','cartbox'),
        'section'       =>  'cartbox_top_header_cart',
        'setting'       =>  'cartbox_general_cart_top_header',
        'priority'      =>  5,
        'type'          =>  'radio',
        'choices'        =>  array(
            'yes'   =>  esc_html__('Yes','cartbox'),
            'no'    =>  esc_html__('No','cartbox')
            )
        )                   
    );

    /** ==================== Header Search Sections And Options ====================**/ 
    $wp_customize->add_panel('cartbox_header_search',array(
        'priority' => '1',
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => esc_html__('Top Header Section','cartbox'),    
    ));
    
    $wp_customize->add_section(
        'cartbox_header_search',
        array(
            'title' =>esc_html__('Header  Advanced Search','cartbox'),
            'panel' =>'cartbox_header_search',
        )
    );
    
    //Header Social Links
    $wp_customize->add_setting('cartbox_header_search_section',
        array(
        'default'           =>  'no',
        'sanitize_callback' =>  'cartbox_sanitize_yes_no',
        )
    );
    $wp_customize->add_control('cartbox_header_search_section',array(
        'description'   =>  esc_html__('Do you want to Enable This Section?','cartbox'),
        'section'       =>  'cartbox_header_search',
        'setting'       =>  'cartbox_header_search_section',
        'priority'      =>  1,
        'type'          =>  'radio',
        'choices'        =>  array(
            'yes'   =>  esc_html__('Yes','cartbox'),
            'no'    =>  esc_html__('No','cartbox')
            )
        )                   
    );
                
    $wp_customize->add_section(
        'cartbox_page_breadcrumb',
        array(
            'title' =>esc_html__('Page Breadcrumb','cartbox'),
            'panel' =>'cartbox_header_search',
        )
    );
    
    $wp_customize->add_setting(
    'cartbox_page_bg_image',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw'
        )
   );
   $wp_customize->add_control(
       new WP_Customize_Image_Control(
           $wp_customize,
           'cartbox_page_bg_image',
           array(
               'label'      => esc_html__( 'Page Breadcrumb Backgeound Image', 'cartbox' ),
               'section'    => 'cartbox_page_breadcrumb',
               'settings'   => 'cartbox_page_bg_image',
               'priority' => 10,
           )
       )
   );             
  /** ==================== Header Social Sections And Options ====================**/
  
  $wp_customize->add_panel('cartbox_header_social_link',array(
    'priority' => '1',
    'capability' => 'edit_theme_options',
    'theme_supports' => '',
    'title' => esc_html__('Header Social Section','cartbox'),    
    ));
    
   $wp_customize->add_section(
        'cartbox_social_link',array(
            'title' =>esc_html__('Header Social Link','cartbox'),
            'panel' =>'cartbox_header_social_link',
        )
    );
    
    //Header Social Links
    $wp_customize->add_setting('cartbox_header_social_section',
        array(
        'default'           =>  'no',
        'sanitize_callback' =>  'cartbox_sanitize_yes_no',
        )
    );
    $wp_customize->add_control('cartbox_header_social_section',array(
        'description'   =>  esc_html__('Do you want to Enable This Section?','cartbox'),
        'section'       =>  'cartbox_social_link',
        'setting'       =>  'cartbox_header_social_section',
        'priority'      =>  1,
        'type'          =>  'radio',
        'choices'        =>  array(
            'yes'   =>  esc_html__('Yes','cartbox'),
            'no'    =>  esc_html__('No','cartbox')
            )
        )                   
    );   
                   
    $wp_customize->add_setting(
    'cartbox_facebook_text',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
    'cartbox_facebook_text', array(
            'label' => esc_html__('Facebook Link','cartbox'),
            'section' => 'cartbox_social_link',
            'type' => 'text',
        )
    );
    
    $wp_customize->add_setting(
    'cartbox_twitter_text',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
    'cartbox_twitter_text',array(
            'label' => esc_html__('Twitter Link','cartbox'),
            'section' => 'cartbox_social_link',
            'type' => 'text',
        )
    );
    
    $wp_customize->add_setting(
    'cartbox_googleplus_text',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
    'cartbox_googleplus_text',array(
            'label' => esc_html__('GooglePlus Link','cartbox'),
            'section' => 'cartbox_social_link',
            'type' => 'text',
        )
    );
    
    $wp_customize->add_setting(
    'cartbox_youtube_text',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
    'cartbox_youtube_text',array(
            'label' => esc_html__('Youtube Link','cartbox'),
            'section' => 'cartbox_social_link',
            'type' => 'text',
        )
    );
    
    $wp_customize->add_setting(
    'cartbox_pinterest_text',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
    'cartbox_pinterest_text',array(
            'label' => esc_html__('Pinterest Link','cartbox'),
            'section' => 'cartbox_social_link',
            'type' => 'text',
        )
    );
    
    $wp_customize->add_setting(
    'cartbox_linkedin_text',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
        'cartbox_linkedin_text',array(
                'label' => esc_html__('Linkedin Link','cartbox'),
                'section' => 'cartbox_social_link',
                'type' => 'text',
            )
    );
    
    $wp_customize->add_setting(
    'cartbox_instagram_text',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
    'cartbox_instagram_text',array(
            'label' => esc_html__('Instagram Link','cartbox'),
            'section' => 'cartbox_social_link',
            'type' => 'text',
        )
    ); 
         

	/** ==================== Home Panel Sections And Options ====================**/
	$wp_customize->add_panel('cartbox_homepage_setups',array(
		'priority' => '3',
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__('Home Section','cartbox'),		
	));
	
	//Adding the Slider Setup Panel
	$wp_customize->add_section('cartbox_slider_setups',array(
    	'priority' => '1',
    	'capability' => 'edit_theme_options',
    	'theme_supports' => '',
    	'title' => esc_html__('Slider Section','cartbox'),
    	'description' => esc_html__('Manage Slides for the site','cartbox'),
    	'panel' => 'cartbox_homepage_setups'
	));
    
    //slider section
	$wp_customize->add_setting('cartbox_home_slider_section',
        array(
            'default'           =>  'no',
            'sanitize_callback' =>  'cartbox_sanitize_yes_no',
        )
    );
    $wp_customize->add_control('cartbox_home_slider_section',array(
        'description'   =>  esc_html__('Do you want to Enable This Section?','cartbox'),
        'section'       =>  'cartbox_slider_setups',
        'setting'       =>  'cartbox_home_slider_section',
        'priority'      =>  1,
        'type'          =>  'radio',
        'choices'        =>  array(
            'yes'   =>  esc_html__('Yes','cartbox'),
            'no'    =>  esc_html__('No','cartbox')
            )
        )                   
    );
   	//select category for slider
   	$wp_customize->add_setting('cartbox_home_slider_category',array(
        'default'           =>  '0',
        'sanitize_callback' =>  'cartbox_sanitize_category',
        )
    );
    $wp_customize->add_control(
    'cartbox_home_slider_category',array(
        'priority'      =>  2,
        'label'         =>  esc_html__('Select Category For Slider','cartbox'),
        'section'       =>  'cartbox_slider_setups',
        'setting'       =>  'cartbox_home_slider_category',
        'type'          =>  'select',  
        'choices'       =>  $cartbox_category_lists
        )                                     
    );
    
    /** ==================== Footer Panel  ====================**/  
    $wp_customize -> add_panel(
        'cartbox_footer_setting_panel',array(
            'priority' => 35,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__('Footer Section', 'cartbox')
        )
    );
    $wp_customize->add_section(
        'cartbox_footer_cpy',array(
            'title' =>esc_html__('Footer Copyright Section','cartbox'),
            'panel' =>'cartbox_footer_setting_panel',
        )
    );
    
    //Starting footer cpy setting
    $wp_customize->add_setting(
    'cartbox_footer_setting_cpy_text',array(
        'default'           =>  esc_html__('Free WordPress Theme','cartbox'),
        'sanitize_callback' =>  'sanitize_text_field',
        'transport'         =>  'postMessage',
        )
    );
    $wp_customize->add_control(
    'cartbox_footer_setting_cpy_text',array(
        'priority'      =>  8,
        'label'         =>  esc_html__('Footer Copyright text','cartbox'),
        'section'       =>  'cartbox_footer_cpy',
        'setting'       =>  'cartbox_footer_setting_cpy_text',
        'type'          =>  'text',  
        )   
    );

 }
add_action( 'customize_register', 'cartbox_custom_customize_register' );

