<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package cartbox
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'cartbox' ); ?></a>

<header id="masthead" class="site-header">
	<div class="header-top">
		<div class="tr-container">
			<div class="site-branding">
				<?php
				the_custom_logo();
				if ( is_front_page() && is_home() ) : ?>
					<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php else : ?>
					<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
				endif;
				$description = get_bloginfo( 'description', 'display' );
				if ( $description || is_customize_preview() ) : ?>
					<p class="site-description"><?php echo esc_html($description); /* WPCS: xss ok. */ ?></p>
				<?php
				endif; ?>
				
		     </div><!-- .site-branding -->
			<div class="header-search">
               <?php do_action('cartbox_header_product_search_action'); ?><!-- search section -->
            </div>
            <?php $cartbox_cart_enable = get_theme_mod('cartbox_general_cart_top_header');
				if($cartbox_cart_enable){ ?>
				    <div class="cart-header">
						 <?php
					    if(is_active_sidebar('cartbox-menu-cart')){?>
						    <div class="header-cart">
						        <span class="cart-icon">
							         <i class="fa fa-shopping-basket"></i>
							         <span class="cart-count"><?php echo absint(WC()->cart->get_cart_contents_count()); ?></span>
						        </span><?php
						             dynamic_sidebar('cartbox-menu-cart');?>
						    </div>
						<?php } ?>
				    </div>
				<?php } ?>
        </div>
    </div> 
	<nav id="site-navigation" class="main-navigation">
	    <div class="tr-container">
		<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( 'Primary Menu', 'cartbox' ); ?></button>
		    <?php
			wp_nav_menu( array(
			    'theme_location' => 'cartbox-menu-1',
				'menu_id'        => 'primary-menu',
					) );
				?>
				<div class="cartbox_header_icon">
	                <?php 
	                $cartbox_social_link = (get_theme_mod('cartbox_header_social_section','no') == 'yes');
	                    if($cartbox_social_link){
	                    do_action('cartbox_social_link_action');
	                    } ?>
	            </div>	   
	    </div>        
	</nav><!-- #site-navigation -->
	</header><!-- #masthead -->
    
    <?php if(is_home() || is_front_page()){
        
        $cartbox_home_slider_section = get_theme_mod('cartbox_home_slider_section');
        if($cartbox_home_slider_section == 'yes'){
            do_action('cartbox_slider_callback_action');
        }
    } ?>
    <!-- Page breadcrumbs -->
    <?php if(!is_home() && !is_front_page()){
        do_action('cartbox_title'); 
    } ?>
    
    
	<div id="content" class="site-content">