<?php
/**
 * Template part for displaying Slider Section
 *
 * @package carpenter-wood-works
 */

$carpenter_wood_works_data_slick_speed = carpenter_wood_works_get_option('data_slick_speed');
$carpenter_wood_works_data_slick_infinite = carpenter_wood_works_get_option('data_slick_infinite');
$carpenter_wood_works_data_slick_dots = carpenter_wood_works_get_option('data_slick_dots');
$carpenter_wood_works_data_slick_autoplay = carpenter_wood_works_get_option('data_slick_autoplay');
$carpenter_wood_works_data_slick_draggable = carpenter_wood_works_get_option('data_slick_draggable');
$carpenter_wood_works_data_slick_fade = carpenter_wood_works_get_option('data_slick_fade');
$carpenter_wood_works_featured_slider_content_type = carpenter_wood_works_get_option('featured_slider_content_type');
$carpenter_wood_works_number_of_featured_slider_items = carpenter_wood_works_get_option('number_of_featured_slider_items');

?>
<?php if (!get_theme_mod('carpenterwoodworks_slider_enable_section', true)) {
    return;
} ?>

<?php
// Convert numeric options to boolean strings for slick carousel
$carpenter_wood_works_data_slick_infinite = $carpenter_wood_works_data_slick_infinite ? 'true' : 'false';
$carpenter_wood_works_data_slick_dots = $carpenter_wood_works_data_slick_dots ? 'true' : 'false';
$carpenter_wood_works_data_slick_autoplay = $carpenter_wood_works_data_slick_autoplay ? 'true' : 'false';
$carpenter_wood_works_data_slick_draggable = $carpenter_wood_works_data_slick_draggable ? 'true' : 'false';
$carpenter_wood_works_data_slick_fade = $carpenter_wood_works_data_slick_fade ? 'true' : 'false';
?>

<div id="featured-slider">
    <div class="section-content"
        data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": <?php echo esc_attr($carpenter_wood_works_data_slick_infinite); ?>, "speed": <?php echo esc_attr($carpenter_wood_works_data_slick_speed); ?>, "dots": <?php echo esc_attr($carpenter_wood_works_data_slick_dots); ?>, "autoplay": <?php echo esc_attr($carpenter_wood_works_data_slick_autoplay); ?>, "draggable": <?php echo esc_attr($carpenter_wood_works_data_slick_draggable); ?>, "fade": <?php echo esc_attr($carpenter_wood_works_data_slick_fade); ?> }'>

        <?php
        $carpenter_wood_works_number_of_featured_slider_items = absint(get_theme_mod('number_of_featured_slider_items', 5)); // Ensure the value is an integer
        
        // Ensure the number of posts starts from 1, and not showing any extras
        if ($carpenter_wood_works_number_of_featured_slider_items < 1) {
            $carpenter_wood_works_number_of_featured_slider_items = 1; // Ensure minimum value is 1
        }

        ?> <?php $carpenter_wood_works_slider_pages = array();
         for ($carpenter_wood_works_count = 1; $carpenter_wood_works_count <= 4; $carpenter_wood_works_count++) {
             $carpenter_wood_works_mod = intval(get_theme_mod('select_post_slider' . $carpenter_wood_works_count));
             if ('page-none-selected' != $carpenter_wood_works_mod) {
                 $carpenter_wood_works_slider_pages[] = $carpenter_wood_works_mod;
             }
         }
         if (!empty($carpenter_wood_works_slider_pages)):
             $carpenter_wood_works_args = array(
                 'post_type' => 'post',
                 'post__in' => $carpenter_wood_works_slider_pages,
                 'posts_per_page' => $carpenter_wood_works_number_of_featured_slider_items,
                 'orderby' => 'post__in'
             );
             $carpenter_wood_works_catquery = new WP_Query($carpenter_wood_works_args);

             $carpenter_wood_works_catquery_counter = 0; // Initialize counter
             while ($carpenter_wood_works_catquery->have_posts() && $carpenter_wood_works_catquery_counter < $carpenter_wood_works_number_of_featured_slider_items):
                 $carpenter_wood_works_catquery->the_post();
                 $carpenter_wood_works_catquery_counter++;
                 ?>
                <article>
                    <div class="opbg">
                        <div class="slide-inner slide-bg-image">
                            <div class="sliderimg">
                                <?php if (has_post_thumbnail()): ?>
                                    <?php $carpenter_wood_works_total_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); ?>
                                    <img class="slide-mainimg" alt="<?php echo esc_attr(get_the_title()); ?>"
                                        src="<?php echo esc_url($carpenter_wood_works_total_slider_image[0]); ?>">
                                <?php endif; ?>
                            </div>
                              <div class="sideimg">
                                <?php
                                $carpenter_wood_works_slider_image1 = get_theme_mod('carpenter_wood_works_slider_image1');
                                if (!empty($carpenter_wood_works_slider_image1)) {
                                    echo '<img alt="' . esc_html(get_the_title()) . '" src="' . esc_url($carpenter_wood_works_slider_image1) . '" />';
                                } else {
                                    echo '<img alt="About us" style="width: 100%; height: 100%; object-fit: cover;" src="' . get_template_directory_uri() . '/assets\images\slidersideimg.png"/>   ';
                                }
                                ?>
                            </div>
                            <div class="row d-flex align-items-center">
                                <div class="slider-inner-mainbox">
                                    <?php if (get_theme_mod('featured_slider_overlayimg_enable', true)): ?>
                                        <!-- Additional content if enabled -->
                                    <?php endif; ?>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 leftcontentbox <?php echo esc_attr(get_theme_mod('carpenter_wood_works_featured_slider_onload_effects', 'wow zoomIn')); ?>"
                                        data-wow-duration="2s">


                                        <div class="wrapper animated <?php echo esc_attr(get_theme_mod('carpenter_wood_works_featured_slider_onload_effects', 'wow Bounce In Up')); ?>"
                                            data-wow-duration="2s">
                                            <div class="entry-container">
                                                <header class="entry-header header">
                                                    <div class="read-more">
                                                        <h2 class="entry-title"
                                                            style="text-transform : <?php if (get_theme_mod('featured_slider_title_case', 'Uppercase') == 'Uppercase') { ?> Uppercase <?php } elseif (get_theme_mod('featured_slider_title_case', 'Capitalize') == 'Capitalize') { ?> Capitalize <?php } elseif (get_theme_mod('featured_slider_title_case', 'Lowercase') == 'Lowercase') { ?> Lowercase <?php } elseif (get_theme_mod('featured_slider_title_case', 'None') == 'None') { ?> none <?php } ?>">
                                                            <?php the_title(); ?>
                                                        </h2>
                                                    </div>
                                                </header>
                                                <div class="sliderparaimg">
                                                    <div class="row">
                                                        <div class="col-sm-12 entry-content content">
                                                            <?php $carpenter_wood_works_excerpt = carpenter_wood_works_the_excerpt(25);
                                                            echo wp_kses_post(wpautop($carpenter_wood_works_excerpt)); ?>

                                                            <div class="py-3">
                                                                <div class="sliderbut1 animated flipInY d-flex">
                                                                    
                                                                <a href="<?php echo esc_url(get_theme_mod('carpenter_wood_works_button1_url', '#')); ?>" class="btn1 btn-custom1 rounded1">
                                                                    <?php echo esc_html(get_theme_mod('carpenter_wood_works_button1_text', 'Read More')); ?>
                                                                </a>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div><!-- .entry-container -->
                                            </div><!-- .wrapper -->
                                        </div><!-- .leftcontentbox -->


                                    </div><!-- .slider-inner-mainbox -->
                                </div><!-- .row -->
                            </div><!-- .slide-inner -->
                        </div><!-- .opbg -->
                </article>
            <?php endwhile; ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div><!-- .section-content -->
</div>
