<?php 
/**
 * Template part for displaying Featured Services Section
 *
 * @package carpenter-wood-works  
 */
$carpenter_wood_works_featured_services_section_maintaitle = carpenter_wood_works_get_option('featured_services_section_maintaitle');
$carpenter_wood_works_featured_services_section_subtitle = carpenter_wood_works_get_option('featured_services_section_subtitle');
$carpenter_wood_works_featured_services_section_subtitle1 = carpenter_wood_works_get_option('featured_services_section_subtitle1');
$services_excerpt_mainpagelength = carpenter_wood_works_get_option('services_excerpt_mainpagelength');

// Fetch only the 4 selected page IDs from the Customizer using get_theme_mod()
$featured_services_posts = array_filter(array(
    get_theme_mod('featured_services_page_1'),
    get_theme_mod('featured_services_page_2'),
    get_theme_mod('featured_services_page_3'),
    get_theme_mod('featured_services_page_4'),
));
?>

<?php if (!get_theme_mod('carpenterwoodworks_enable_featured_services_section', true)) {
     return;
} ?>

<section id="featured-services">
    <div class="container-fluid p-0">
    <div class="row py-4">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="entry-content3 text-center">
                <h5><span class="icon"></span><?php echo esc_html($carpenter_wood_works_featured_services_section_maintaitle); ?></h5>
                <h6><?php echo esc_html($carpenter_wood_works_featured_services_section_subtitle); ?></h6>
                <h6><?php echo esc_html($carpenter_wood_works_featured_services_section_subtitle1); ?></h6>
            </div>
        </div>
    </div>

    <div class="row py-4">
        <div class="grid xl:grid-cols-4 lg:grid-cols-4 md:grid-cols-2 sm:grid-cols-1 grid-cols-1 servicerightside gap-3">

            <?php
            if (!empty($featured_services_posts)) :
                $args = array(
                    'post_type' => 'page',
                    'post__in' => $featured_services_posts,
                    'posts_per_page' => count($featured_services_posts),
                    'orderby' => 'post__in',
                );
                $query = new WP_Query($args);

                if ($query->have_posts()) :
                    while ($query->have_posts()) : $query->the_post();
                        $image = has_post_thumbnail()
                            ? wp_get_attachment_image_src(get_post_thumbnail_id(), 'single-post-thumbnail')
                            : array(get_template_directory_uri() . '/assets/images/no-images.jpg');
                        $image_height = esc_attr(get_theme_mod('featured_services_post_image_height', '492'));
                        $onload_effect = esc_attr(get_theme_mod('carpenter_wood_works_featured_services_onload_effects', 'wow zoomIn'));
                        $text_align = strtolower(get_theme_mod('featured_services_box_align', 'Left'));
                        ?>
                        <article class="paddingdiv <?php echo $onload_effect; ?>" data-wow-duration="2s">
                            <a href="<?php the_permalink(); ?>">
                                <div class="featured-service-item h-full" style="text-align: <?php echo esc_attr($text_align); ?>;">
                                    <div class="entry-container relative">
                                        <?php if ($image): ?>
                                            <div style="background-size: 100% 100%; background-image: url(<?php echo esc_url($image[0]); ?>); height: <?php echo $image_height; ?>px;">
                                                <div class="absolute">
                                                    <hr>
                                                    <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                                    <?php
                                                    $excerpt = carpenter_wood_works_the_excerpt($services_excerpt_mainpagelength);
                                                    echo wp_kses_post(wpautop($excerpt));
                                                    ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div><!-- .entry-container -->
                                </div>
                            </a>
                        </article>
                    <?php endwhile;
                    wp_reset_postdata();
                endif;
            endif;
            ?>
        </div>
    </div>
    </div>
</section>
