<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package carpenter-wood-works
 */
?>

<aside id="secondary" class="widget-area">
	<?php dynamic_sidebar( 'sidebar-1' ); ?>
</aside><!-- #secondary -->

<?php 
  if ( ! is_active_sidebar( 'sidebar-1' )) { ?>
<aside id="secondary" class="widget-area">
    <section id="Search" class="widget widget_block widget_archive ">
        <h2 class="widget-title"><?php esc_html_e('Search', 'carpenter-wood-works'); ?></h2>
        <?php get_search_form(); ?>
    </section>
    <section id="recent-posts" class="widget" role="complementary">
        <h2 class="widget-title"><?php esc_html_e('Recent Posts', 'carpenter-wood-works'); ?></h2>
        <ul class="recent-posts-list">
            <?php
		        $carpenter_wood_works_recent_posts = get_posts(array(
		            'numberposts' => 5, // Adjust the number of posts to display
		            'post_status' => 'publish',
		        ));

		        foreach ($carpenter_wood_works_recent_posts as $carpenter_wood_works_post) :
		            setup_postdata($carpenter_wood_works_post);
		            ?>
            <li>
                <a href="<?php echo get_permalink($carpenter_wood_works_post->ID); ?>">
                    <?php echo esc_html(get_the_title($carpenter_wood_works_post->ID)); ?>
                </a>
            </li>
            <?php
		        endforeach;
		        wp_reset_postdata();
		        ?>
        </ul>
    </section>
    <section id="archives" class="widget widget_block widget_archive ">
        <h2 class="widget-title"><?php esc_html_e('Archives', 'carpenter-wood-works'); ?></h2>
        <ul>
            <?php
		        wp_get_archives(array(
		            'type'            => 'monthly',
		            'show_post_count' => true,
		        ));
		        ?>
        </ul>
    </section>
    <section id="categories" class="widget widget_categories" role="complementary">
        <h2 class="widget-title"><?php esc_html_e('Categories', 'carpenter-wood-works'); ?></h2>
        <ul>
            <?php
		        wp_list_categories(array(
		            'orderby'    => 'name',
		            'title_li'   => '',
		            'show_count' => true,
		        ));
		        ?>
        </ul>
    </section>


</aside><!-- #secondary -->
<?php } ?>
