<?php

/**
 * Header Theme Options
 *
 * @package carpenter-wood-works
 */
$wp_customize->add_section('carpenter_wood_works_header_section', array(

	'title'      => esc_html__('Header Section', 'carpenter-wood-works'),
	'capability' => 'edit_theme_options',
	'panel' => 'carpenter_wood_works_theme_section_panel'

));

// Instagram Link
$wp_customize->add_setting( 'carpenter_wood_works_head_insta_link', array(
    'default'           => '#',
    'sanitize_callback' => 'esc_url_raw', // ✅ Use proper URL sanitizer
) );

$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'carpenter_wood_works_head_insta_link', array(
    'label'    => esc_html__( 'Instagram Link', 'carpenter-wood-works' ),
    'section'  => 'carpenter_wood_works_header_section',
    'settings' => 'carpenter_wood_works_head_insta_link',
    'type'     => 'text',
) ) );

// pinterest Link
$wp_customize->add_setting( 'carpenter_wood_works_head_pinterest_link', array(
    'default'           => '#',
    'sanitize_callback' => 'esc_url_raw', // ✅ Use proper URL sanitizer
) );

$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'carpenter_wood_works_head_pinterest_link', array(
    'label'    => esc_html__( 'Pinterest Link', 'carpenter-wood-works' ),
    'section'  => 'carpenter_wood_works_header_section',
    'settings' => 'carpenter_wood_works_head_pinterest_link',
    'type'     => 'text',
) ) );

// facebook Link
$wp_customize->add_setting( 'carpenter_wood_works_head_facebook_link', array(
    'default'           => '#',
    'sanitize_callback' => 'esc_url_raw', // ✅ Use proper URL sanitizer
) );

$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'carpenter_wood_works_head_facebook_link', array(
    'label'    => esc_html__( 'Facebook Link', 'carpenter-wood-works' ),
    'section'  => 'carpenter_wood_works_header_section',
    'settings' => 'carpenter_wood_works_head_facebook_link',
    'type'     => 'text',
) ) );

// twitter Link
$wp_customize->add_setting( 'carpenter_wood_works_head_twitter_link', array(
    'default'           => '#',
    'sanitize_callback' => 'esc_url_raw', // ✅ Use proper URL sanitizer
) );

$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'carpenter_wood_works_head_twitter_link', array(
    'label'    => esc_html__( 'Twitter Link', 'carpenter-wood-works' ),
    'section'  => 'carpenter_wood_works_header_section',
    'settings' => 'carpenter_wood_works_head_twitter_link',
    'type'     => 'text',
) ) );





//  Phone Number 
$wp_customize->add_setting( 'carpenter_wood_works_head_phonenumber' , array(
    'default'   => '(+00)1233 4566',   
    'sanitize_callback' => 'carpenter_wood_works_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'carpenter_wood_works_head_phonenumber', array(   
    'label'      => esc_html__( 'Phone Number', 'carpenter-wood-works' ),   
    'section'    => 'carpenter_wood_works_header_section',   
    'settings'   => 'carpenter_wood_works_head_phonenumber',   
    'type' => 'text',         
) ) );

//  mail 
$wp_customize->add_setting( 'carpenter_wood_works_head_mail' , array(
    'default'   => 'carpenterwoodworks@demo.com',   
    'sanitize_callback' => 'carpenter_wood_works_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'carpenter_wood_works_head_mail', array(   
    'label'      => esc_html__( 'Mail', 'carpenter-wood-works' ),   
    'section'    => 'carpenter_wood_works_header_section',   
    'settings'   => 'carpenter_wood_works_head_mail',   
    'type' => 'text',         
) ) );

// ///////// Button Bg Text Color
$wp_customize->add_setting('menu_bg_color', array(
    'default'   => '#1B130D',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'menu_bg_color', array(
    'section' => 'carpenter_wood_works_header_section',
    'label'      => esc_html__('Menu Bg Color', 'carpenter-wood-works'),
    )));

    // ///////// Info Icon Color
$wp_customize->add_setting('info_icon_color', array(
    'default'   => '#CA8E3E',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'info_icon_color', array(
    'section' => 'carpenter_wood_works_header_section',
    'label'      => esc_html__('Info Icons Color', 'carpenter-wood-works'),
    )));

    // ///////// Social Icon Color
$wp_customize->add_setting('social_icon_color', array(
    'default'   => '#fff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'social_icon_color', array(
    'section' => 'carpenter_wood_works_header_section',
    'label'      => esc_html__('Social Icons Color', 'carpenter-wood-works'),
    )));

    // ///////// Info Text Color
$wp_customize->add_setting('info_text_color', array(
    'default'   => '#CA8E3E',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'info_text_color', array(
    'section' => 'carpenter_wood_works_header_section',
    'label'      => esc_html__('Info Text Color', 'carpenter-wood-works'),
    )));

    // ///////// Menu Text Color
$wp_customize->add_setting('menu_text_color', array(
    'default'   => '#CA8E3E',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'menu_text_color', array(
    'section' => 'carpenter_wood_works_header_section',
    'label'      => esc_html__('Menu Text Color', 'carpenter-wood-works'),
    )));
