<?php
/**
 * Footer Theme Options
 *
 * @package carpenter-wood-works
 */

$wp_customize->add_section( 'carpenter_wood_works_footer_section' , array(
	'title'      => esc_html__( 'Footer Section', 'carpenter-wood-works' ),
	'capability' => 'edit_theme_options',
	'panel' => 'carpenter_wood_works_theme_section_panel'
) );

// Theme Name
$wp_customize->add_setting('carpenter_wood_works_foot_themename', array(
    'default' => '© 2025 . all rights reserved.',
    'sanitize_callback' => 'carpenter_wood_works_sanitise_custom_texttitle',
));

$wp_customize->add_control('carpenter_wood_works_foot_themename', array(
    'label'    => __('Theme Name', 'carpenter-wood-works'),
    'section'  => 'carpenter_wood_works_footer_section',
    'settings' => 'carpenter_wood_works_foot_themename',
    'type'     => 'text',
));

// Author Name
$wp_customize->add_setting('carpenter_wood_works_foot_link_texts', array(
    'default' => 'Follow Us :',
    'sanitize_callback' => 'carpenter_wood_works_sanitise_custom_texttitle',
));

$wp_customize->add_control('carpenter_wood_works_foot_link_texts', array(
    'label'    => __('Footer Bottom Corner Icons Title', 'carpenter-wood-works'),
    'section'  => 'carpenter_wood_works_footer_section',
    'settings' => 'carpenter_wood_works_foot_link_texts',
    'type'     => 'text',
));

// Footer icons 1
$wp_customize->add_setting('carpenter_wood_works_foot_featured_icon_footer1', 
    array(
    'default'           => 'fa-brands fa-facebook-f',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('carpenter_wood_works_foot_featured_icon_footer1', 
    array(
    'label'       => __('Icon 1', 'carpenter-wood-works'),
    'section'     => 'carpenter_wood_works_footer_section',   
    'settings'    => 'carpenter_wood_works_foot_featured_icon_footer1',        
    'type'        => 'text'
));

// Footer icons 1 Url
$wp_customize->add_setting('carpenter_wood_works_featured_icon_url_footer1', 
    array(
    'default'           => ' ', 
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('carpenter_wood_works_featured_icon_url_footer1', 
    array(
    'label'       => __('Icon 1 Url', 'carpenter-wood-works'),
    'section'     => 'carpenter_wood_works_footer_section',   
    'settings'    => 'carpenter_wood_works_featured_icon_url_footer1',        
    'type'        => 'text'
));

// Footer icons 2
$wp_customize->add_setting('carpenter_wood_works_foot_featured_icon_footer2', 
    array(
    'default'           => 'fa-brands fa-twitter',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('carpenter_wood_works_foot_featured_icon_footer2', 
    array(
    'label'       => __('Icon 2', 'carpenter-wood-works'),
    'section'     => 'carpenter_wood_works_footer_section',   
    'settings'    => 'carpenter_wood_works_foot_featured_icon_footer2',        
    'type'        => 'text'
));

// Footer icons 2 Url
$wp_customize->add_setting('carpenter_wood_works_featured_icon_url_footer2', 
    array(
    'default'           => ' ', 
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('carpenter_wood_works_featured_icon_url_footer2', 
    array(
    'label'       => __('Icon 2 Url', 'carpenter-wood-works'),
    'section'     => 'carpenter_wood_works_footer_section',   
    'settings'    => 'carpenter_wood_works_featured_icon_url_footer2',        
    'type'        => 'text'
));

// Footer icons 3
$wp_customize->add_setting('carpenter_wood_works_foot_featured_icon_footer3', 
    array(
    'default'           => 'fa-brands fa-instagram',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('carpenter_wood_works_foot_featured_icon_footer3', 
    array(
    'label'       => __('Icon 3', 'carpenter-wood-works'),
    'section'     => 'carpenter_wood_works_footer_section',   
    'settings'    => 'carpenter_wood_works_foot_featured_icon_footer3',        
    'type'        => 'text'
));

// Footer icons 3 Url
$wp_customize->add_setting('carpenter_wood_works_featured_icon_url_footer3', 
    array(
    'default'           => ' ', 
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('carpenter_wood_works_featured_icon_url_footer3', 
    array(
    'label'       => __('Icon 3 Url', 'carpenter-wood-works'),
    'section'     => 'carpenter_wood_works_footer_section',   
    'settings'    => 'carpenter_wood_works_featured_icon_url_footer3',        
    'type'        => 'text'
));