<?php 
/**
 * Home Section
 *
 * @package carpenter-wood-works
 */

$carpenter_wood_works_default = carpenter_wood_works_get_default_theme_options();

/** Slider Info section */
$wp_customize->add_section(
    'carpenterwoodworks_featured_slider_info_section',
    array(
        'title'    => __( 'Slider Info', 'carpenter-wood-works' ),      
        'priority' => 1,
        'panel'      => 'carpenter_wood_works_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting(
    'carpenterwoodworks_slider_enable_section',
    array(
        'default' 			=> true,
       'sanitize_callback' => 'carpenter_wood_works_sanitize_switch',

    )
);
$wp_customize->add_control(
    new Carpenter_Wood_Works_Toggle_Checkbox_Custom_control(
        $wp_customize,
        'carpenterwoodworks_slider_enable_section',
        array(
            'settings'      => 'carpenterwoodworks_slider_enable_section',
            'section'       => 'carpenterwoodworks_featured_slider_info_section',
            'label'         => __( 'Enable Section', 'carpenter-wood-works' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'carpenter-wood-works' ),
                'off' => __( 'No', 'carpenter-wood-works' )
            ),
        )
    )
);

// /// effects
$wp_customize->add_setting('carpenter_wood_works_featured_slider_onload_effects',array(
    'default' => 'Bounce In Up',
    'sanitize_callback' => 'carpenter_wood_works_sanitize_choices',
));
$wp_customize->add_control('carpenter_wood_works_featured_slider_onload_effects',array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects','carpenter-wood-works'),
    'choices' => array (
        'wow bounceInLeft' => __('Bounce In Left','carpenter-wood-works'),
        'wow bounceInRight' => __('Bounce In Right','carpenter-wood-works'),
        'wow bounceInUp' => __('Bounce In Up','carpenter-wood-works'),
        'wow bounceInDown' => __('Bounce In Down','carpenter-wood-works'),
        'wow zoomIn' => __('Zoom In','carpenter-wood-works'),
        'wow zoomOut' => __('Zoom Out','carpenter-wood-works'),
        'wow fadeInDown' => __('Fade In Down','carpenter-wood-works'),            
        'wow fadeInUp' => __('Fade In Up','carpenter-wood-works'),
        'wow fadeInLeft' => __('Fade In Left','carpenter-wood-works'),
        'wow fadeInRight' => __('Fade In Right','carpenter-wood-works'),
        'flip-up' => __('Flip Up','carpenter-wood-works')
    ),
    'section' => 'carpenterwoodworks_featured_slider_info_section',
)); 

// Items
// Number of Slider Items
$wp_customize->add_setting('number_of_featured_slider_items', array(
    'default'           => 3, // Set default number of items
    'sanitize_callback' => 'absint', // Ensure it's a valid integer
));

$wp_customize->add_control('number_of_featured_slider_items', array(
    'label'    => __('Number Of Slider To Show', 'carpenter-wood-works'),
    'section'  => 'carpenterwoodworks_featured_slider_info_section', // The section where this control will appear
    'type'     => 'number',
    'input_attrs' => array(
        'min' => 1, // Minimum value
        'max' => 10, // Maximum value
        'step' => 1, // Increment step
    ),
));

$carpenter_wood_works_slider_list = array();
$carpenter_wood_works_args = array('post_type' => 'post'); // Fetch posts, not pages
$carpenter_wood_works_posts = get_posts( $carpenter_wood_works_args ); 
foreach($carpenter_wood_works_posts as $carpenter_wood_works_post) {
    $carpenter_wood_works_slider_list[$carpenter_wood_works_post->ID] = $carpenter_wood_works_post->post_title; // Use post ID as key and title as value
}

for ( $carpenter_wood_works_count = 1; $carpenter_wood_works_count <= 3; $carpenter_wood_works_count++ ) {
    $wp_customize->add_setting( 'select_post_slider' . $carpenter_wood_works_count, array(
        'default'           => '',
        'sanitize_callback' => 'carpenter_wood_works_sanitize_post_dropdown'
    ));
    $wp_customize->add_control( 'select_post_slider' . $carpenter_wood_works_count, array(
        'label'   => __( 'Select A Post Page', 'carpenter-wood-works' ),
        'section' => 'carpenterwoodworks_featured_slider_info_section',
        'type'    => 'select', // Use 'select' for custom post list
        'choices' => $carpenter_wood_works_slider_list // Populate choices with posts
    ));
}


////////// Button

$wp_customize->add_setting('carpenter_wood_works_button1_text', 
    array(
    'default'           => __('Read More', 'carpenter-wood-works'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('carpenter_wood_works_button1_text', 
    array(
    'label'       => __('Button Text', 'carpenter-wood-works'),
    'section'     => 'carpenterwoodworks_featured_slider_info_section',   
    'settings'    => 'carpenter_wood_works_button1_text',           
    'type'        => 'text'
    )
);
// Button URL
$wp_customize->add_setting( 'carpenter_wood_works_button1_url', array(
    'default'           => 'Enter the Button URL',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control( 'carpenter_wood_works_button1_url', array(
    'label'       => __( 'Button URL', 'carpenter-wood-works' ),
    'section'     => 'carpenterwoodworks_featured_slider_info_section',
    'settings'    => 'carpenter_wood_works_button1_url',
    'type'        => 'url',
));
