<?php
/**
 * About Section options.
 *
 * @package carpenter-wood-works
 */

$carpenter_wood_works_default = carpenter_wood_works_get_default_theme_options();


$wp_customize->add_section(
    'carpenterwoodworks_featured_services_info_section',
    array(
        'title' => __('Service Info', 'carpenter-wood-works'),
        'priority' => 3,
        'panel' => 'carpenter_wood_works_section_panel',
    )
);

// Enable Section
$wp_customize->add_setting('carpenterwoodworks_enable_featured_services_section', 
	array(
	'default' 			=> $carpenter_wood_works_default['carpenterwoodworks_enable_featured_services_section'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'carpenter_wood_works_sanitize_switch'
	)
);

$wp_customize->add_control('carpenterwoodworks_enable_featured_services_section', 
	array(		
	'label' 	=> __('Enable Section', 'carpenter-wood-works'),
	'section' 	=> 'carpenterwoodworks_featured_services_info_section',
	'settings'  => 'carpenterwoodworks_enable_featured_services_section',
	'type' 		=> 'checkbox',	
	)
);


// /// effects
$wp_customize->add_setting('carpenter_wood_works_featured_services_onload_effects', array(
    'default' => 'zoom-in',
    'sanitize_callback' => 'carpenter_wood_works_sanitize_choices',
));
$wp_customize->add_control('carpenter_wood_works_featured_services_onload_effects', array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects', 'carpenter-wood-works'),
    'choices' => array(
        'wow bounceInLeft' => __('Bounce In Left', 'carpenter-wood-works'),
        'wow bounceInRight' => __('Bounce In Right', 'carpenter-wood-works'),
        'wow bounceInUp' => __('Bounce In Up', 'carpenter-wood-works'),
        'wow bounceInDown' => __('Bounce In Down', 'carpenter-wood-works'),
        'wow zoomIn' => __('Zoom In', 'carpenter-wood-works'),
        'wow zoomOut' => __('Zoom Out', 'carpenter-wood-works'),
        'wow fadeInDown' => __('Fade In Down', 'carpenter-wood-works'),
        'wow fadeInUp' => __('Fade In Up', 'carpenter-wood-works'),
        'wow fadeInLeft' => __('Fade In Left', 'carpenter-wood-works'),
        'wow fadeInRight' => __('Fade In Right', 'carpenter-wood-works'),
        'flip-up' => __('Flip Up', 'carpenter-wood-works')
    ),
    'section' => 'carpenterwoodworks_featured_services_info_section',
));

// Section Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_maintaitle]',
    array(
        'default' => $carpenter_wood_works_default['featured_services_section_maintaitle'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_maintaitle]',
    array(
        'label' => __('Heading', 'carpenter-wood-works'),
        'section' => 'carpenterwoodworks_featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_maintaitle]',
        'type' => 'text'
    )
);

// Section Sub-Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_subtitle]',
    array(
        'default' => $carpenter_wood_works_default['featured_services_section_subtitle'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_subtitle]',
    array(
        'label' => __('Sub Heading 1', 'carpenter-wood-works'),
        'section' => 'carpenterwoodworks_featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_subtitle]',
        'type' => 'text'
    )
);
// Section Sub-Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_subtitle1]',
    array(
        'default' => $carpenter_wood_works_default['featured_services_section_subtitle1'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_subtitle1]',
    array(
        'label' => __('Sub Heading 2', 'carpenter-wood-works'),
        'section' => 'carpenterwoodworks_featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_subtitle1]',
        'type' => 'text'
    )
);


$wp_customize->add_setting('featured_services_page_1', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_1', array(
    'label' => __('Select Page 1', 'carpenter-wood-works'),
    'section' => 'carpenterwoodworks_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

$wp_customize->add_setting('featured_services_page_2', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_2', array(
    'label' => __('Select Page 2', 'carpenter-wood-works'),
    'section' => 'carpenterwoodworks_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

$wp_customize->add_setting('featured_services_page_3', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_3', array(
    'label' => __('Select Page 3', 'carpenter-wood-works'),
    'section' => 'carpenterwoodworks_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

$wp_customize->add_setting('featured_services_page_4', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_4', array(
    'label' => __('Select Page 4', 'carpenter-wood-works'),
    'section' => 'carpenterwoodworks_featured_services_info_section',
    'type' => 'dropdown-pages',
)));
