<?php
/**
 * About Section options.
 *
 * @package carpenter-wood-works
 */

$carpenter_wood_works_default = carpenter_wood_works_get_default_theme_options();

/** About Info section */
$wp_customize->add_section(
    'carpenterwoodworks_featured_about_info_section',
    array(
        'title'    => __( 'About Info', 'carpenter-wood-works' ),      
        'priority' => 2,
        'panel'      => 'carpenter_wood_works_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting('carpenterwoodworks_enable_featured_about_section', 
	array(
	'default' 			=> $carpenter_wood_works_default['carpenterwoodworks_enable_featured_about_section'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'carpenter_wood_works_sanitize_switch'
	)
);

$wp_customize->add_control('carpenterwoodworks_enable_featured_about_section', 
	array(		
	'label' 	=> __('Enable Section', 'carpenter-wood-works'),
	'section' 	=> 'carpenterwoodworks_featured_about_info_section',
	'settings'  => 'carpenterwoodworks_enable_featured_about_section',
	'type' 		=> 'checkbox',	
	)
);

$wp_customize->add_setting('carpenter_wood_works_featured_about_onload_effects', array(
    'default' => 'wow zoomIn',
    'sanitize_callback' => 'carpenter_wood_works_sanitize_choices',
));

$wp_customize->add_control('carpenter_wood_works_featured_about_onload_effects', array(
    'label' => __('Box Onload Transition Effects', 'carpenter-wood-works'),
    'section' => 'carpenterwoodworks_featured_about_info_section',
    'settings' => 'carpenter_wood_works_featured_about_onload_effects',
    'type' => 'select',
    'choices' => array(
        'wow bounceInLeft' => __('Bounce In Left', 'carpenter-wood-works'),
        'wow bounceInRight' => __('Bounce In Right', 'carpenter-wood-works'),
        'wow bounceInUp' => __('Bounce In Up', 'carpenter-wood-works'),
        'wow bounceInDown' => __('Bounce In Down', 'carpenter-wood-works'),
        'wow zoomIn' => __('Zoom In', 'carpenter-wood-works'),
        'wow zoomOut' => __('Zoom Out', 'carpenter-wood-works'),
        'wow fadeInDown' => __('Fade In Down', 'carpenter-wood-works'),
        'wow fadeInUp' => __('Fade In Up', 'carpenter-wood-works'),
        'wow fadeInLeft' => __('Fade In Left', 'carpenter-wood-works'),
        'wow fadeInRight' => __('Fade In Right', 'carpenter-wood-works'),
        'flip-up' => __('Flip Up', 'carpenter-wood-works'),
    ),
));


// Section Title
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_subheading]', 
    array(
        'default'           => $carpenter_wood_works_default['featured_about_section_aboutus_subheading'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_subheading]', 
    array(
        'label'       => __('Sub Heading', 'carpenter-wood-works'),
        'section'     => 'carpenterwoodworks_featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_aboutus_subheading]',		
        'type'        => 'text'
    )
);


// // Section Title
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_heading]', 
	array(
	'default'           => $carpenter_wood_works_default['featured_about_section_aboutus_heading'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_heading]', 
	array(
	'label'       => __('Heading 1', 'carpenter-wood-works'),
	'section'     => 'carpenterwoodworks_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_heading]',		
	'type'        => 'text'
	)
);

// // Section Title
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_heading1]', 
	array(
	'default'           => $carpenter_wood_works_default['featured_about_section_aboutus_heading1'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_heading1]', 
	array(
	'label'       => __('Heading 2', 'carpenter-wood-works'),
	'section'     => 'carpenterwoodworks_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_heading1]',		
	'type'        => 'text'
	)
);

// // Section description
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_description]', 
	array(
	'default'           => $carpenter_wood_works_default['featured_about_section_aboutus_description'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_description]', 
	array(
	'label'       => __('Description', 'carpenter-wood-works'),
	'section'     => 'carpenterwoodworks_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_description]',		
	'type'        => 'text'
	)
);


// // Section box1 heading
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_box1_heading]', 
	array(
	'default'           => $carpenter_wood_works_default['featured_about_section_aboutus_box1_heading'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_box1_heading]', 
	array(
	'label'       => __('Box 1 Heading', 'carpenter-wood-works'),
	'section'     => 'carpenterwoodworks_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_box1_heading]',		
	'type'        => 'text'
	)
);

// // Section box1 description
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_box1_description]', 
	array(
	'default'           => $carpenter_wood_works_default['featured_about_section_aboutus_box1_description'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_box1_description]', 
	array(
	'label'       => __('Box 1 Description', 'carpenter-wood-works'),
	'section'     => 'carpenterwoodworks_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_box1_description]',		
	'type'        => 'text'
	)
);

// // Section box2 heading
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_box2_heading]', 
	array(
	'default'           => $carpenter_wood_works_default['featured_about_section_aboutus_box2_heading'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_box2_heading]', 
	array(
	'label'       => __('Box 2 Heading', 'carpenter-wood-works'),
	'section'     => 'carpenterwoodworks_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_box2_heading]',		
	'type'        => 'text'
	)
);

// // Section box2 description
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_box2_description]', 
	array(
	'default'           => $carpenter_wood_works_default['featured_about_section_aboutus_box2_description'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_box2_description]', 
	array(
	'label'       => __('Box 2 Description', 'carpenter-wood-works'),
	'section'     => 'carpenterwoodworks_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_box2_description]',		
	'type'        => 'text'
	)
);

//Section Image
$wp_customize->add_setting( 'carpenter_wood_works_about_image1', array(  
    'sanitize_callback' => 'carpenter_wood_works_sanitise_custom_url'
    ));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'carpenter_wood_works_about_image1', array(
        'label'      => __( 'Section Image', 'carpenter-wood-works' ),
        'section'    => 'carpenterwoodworks_featured_about_info_section',
        'settings'   => 'carpenter_wood_works_about_image1',
)));
