<?php
/**
 * Default theme options.
 *
 * @package carpenter-wood-works
 */

if ( ! function_exists( 'carpenter_wood_works_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0
	 *
	 * @return array Default theme options.
	 */
function carpenter_wood_works_get_default_theme_options() {

	$carpenter_wood_works_defaults = array();
	

    // Front Page Content
	$carpenter_wood_works_defaults['enable_frontpage_content'] 		= true;

	// Slider Section	
	$carpenter_wood_works_defaults['enable_featured_slider_section']		    	= true;
	//$carpenter_wood_works_defaults['show_slider_colors']		    			= false;	
	$carpenter_wood_works_defaults['featured_slider_content_type']		    	= 'featured_slider_page';
	$carpenter_wood_works_defaults['featured_slider_category_readmore_text']		= esc_html__('Read More','carpenter-wood-works');
	$carpenter_wood_works_defaults['data_slick_speed']					    	= 1000;
	$carpenter_wood_works_defaults['data_slick_infinite']				    	= 1;
	$carpenter_wood_works_defaults['data_slick_dots']					    	= 1;
	$carpenter_wood_works_defaults['data_slick_autoplay']				    	= 1;
	$carpenter_wood_works_defaults['data_slick_draggable']				    	= 1;
	$carpenter_wood_works_defaults['data_slick_fade']					    	= 1;
	$carpenter_wood_works_defaults['number_of_featured_slider_items']	    	= 6;

	// Features Section
	$carpenter_wood_works_defaults['enable_featured_features_section']			= true;
	//$carpenter_wood_works_defaults['show_feature_colors']						= false;
	$carpenter_wood_works_defaults['number_of_featured_features_items']			= 6;
	$carpenter_wood_works_defaults['featured_features_column']					= 3;
	$carpenter_wood_works_defaults['featured_features_content_type']				= 'featured_features_page';
	$carpenter_wood_works_defaults['feture_section_excerpt']						= 25;
	

	// About Section	
	$carpenter_wood_works_defaults['carpenterwoodworks_enable_featured_about_section']						= true;
    $carpenter_wood_works_defaults['about_image_show'] 									= true;
	$carpenter_wood_works_defaults['featured_about_section_aboutus_subheading']							= esc_html__('who we are', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_about_section_aboutus_heading']							= esc_html__('Providing high quality carpenter solution', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_about_section_aboutus_heading1']							= esc_html__('Our Operations Around The World And Across Various Carpenter Sectors', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_about_section_aboutus_description']							= esc_html__('Carpenters in a powerful way of just not an only professions, however, in a passion for our Company. We have to a tendency to believe the idea that smart looking of any website in a passion', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_about_section_aboutus_box1_heading']							= esc_html__('Reasonable Cost', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_about_section_aboutus_box1_description']							= esc_html__('Lorem Ipsum available, but the majority have suffered', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_about_section_aboutus_box2_heading']							= esc_html__('Expert Services', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_about_section_aboutus_box2_description']							= esc_html__('Lorem Ipsum available, but the majority have suffered', 'carpenter-wood-works' );


	// service Section	

	$carpenter_wood_works_defaults['carpenterwoodworks_enable_featured_services_section']			= true;
	$carpenter_wood_works_defaults['featured_services_section_maintaitle']	    = esc_html__( 'Our Services', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_services_section_subtitle']	    	= esc_html__( 'Providing High Quality Carpenter', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['featured_services_section_subtitle1']	    	= esc_html__( 'Solution', 'carpenter-wood-works' );
	$carpenter_wood_works_defaults['services_excerpt_mainpagelength']			= 11;




	// Inner Blog Page	
	$carpenter_wood_works_defaults['featured_bloginn_botton_text']				= esc_html__( 'Read More', 'carpenter-wood-works' );

	return $carpenter_wood_works_defaults;

}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'carpenter_wood_works_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function carpenter_wood_works_get_option( $key ) {

		$default_options = carpenter_wood_works_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;
