<?php
/**
 * Active callback functions.
 *
 * @package carpenter-wood-works
 */

function carpenter_wood_works_featured_slider_active( $control ) {
    if( $control->manager->get_setting( 'carpenterwoodworks_slider_enable_section' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
function carpenter_wood_works_featured_slider_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_slider_content_type]' )->value();
    return ( carpenter_wood_works_featured_slider_active( $control ) && ( 'featured_slider_page' == $content_type ) );
}


//  About

function carpenter_wood_works_featured_about_active( $control ) {
    if( $control->manager->get_setting( 'theme_options[carpenterwoodworks_enable_featured_about_section]' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
function carpenter_wood_works_featured_about_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_about_content_type]' )->value();
    return ( carpenter_wood_works_featured_about_active( $control ) && ( 'featured_about_page' == $content_type ) );
}
function carpenter_wood_works_featured_services_active( $control ) {
    if( $control->manager->get_setting( 'theme_options[carpenterwoodworks_enable_featured_services_section]' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
function carpenter_wood_works_featured_services_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_services_content_type]' )->value();
    return ( carpenter_wood_works_featured_services_active( $control ) && ( 'featured_services_page' == $content_type ) );
}

function carpenter_wood_works_featured_services_post() {
    return is_single(); // Checks if the current view is a single post
}



/**
 * Active Callback for top bar section
 */
function carpenter_wood_works_contact_info_ac( $control ) {

    $show_contact_info = $control->manager->get_setting( 'theme_options[show_header_contact_info]')->value();
    $control_id        = $control->id;
         
    if ( $control_id == 'theme_options[header_location]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[header_email]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[header_phone]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[hphone_text]' && $show_contact_info ) return true;

    return false;
}

function carpenter_wood_works_social_links_active( $control ) {
    if( $control->manager->get_setting( 'theme_options[show_header_social_links]' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
