<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package carpenter-wood-works
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <div id="page" class="site header">
        <a class="skip-link screen-reader-text"
            href="#primaryid"><?php esc_html_e('Skip to content', 'carpenter-wood-works'); ?></a>
        <header id="masthead" class="site-header">
            <div id="section-header" class="section-header">
                <div class="bottomheader stickyheader <?php echo esc_attr(carpenter_wood_works_sticky_header()); ?>">
                    <div class=""
                        style="<?php if (get_header_image()): ?>background-image: url('<?php echo esc_url(get_header_image()); ?>');<?php endif; ?>background-position: center top;background-size: cover;">
                        <div class="row header-row">
                            <nav id="site-navigation" class="main-navigation navbar navbar-expand-lg">
                                <div class="col-xl-3 col-lg-3 col-md-12 col-12 pd-0 logo">
                                    <div class="sitenave">
                                        <div class="site-branding">
                                            <?php
                                            if (has_custom_logo()) {
                                                the_custom_logo();
                                            } else {
                                                if (is_front_page() && is_home()): ?>
                                                    <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"
                                                            rel="home"><?php bloginfo('name'); ?></a></h1>
                                                <?php else: ?>
                                                    <div class="business-box">
                                                        <div class="business-title-container">
                                                            <h1 class="site-title"><a
                                                                    href="<?php echo esc_url(home_url('/')); ?>"
                                                                    rel="home"><?php bloginfo('name'); ?></a></h1>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <?php
                                                $the_carpenter_wood_works_description = get_bloginfo('description', 'display');
                                                if ($the_carpenter_wood_works_description || is_customize_preview()): ?>
                                                    <p class="site-description">
                                                        <?php echo $the_carpenter_wood_works_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                                    </p>
                                                <?php endif;
                                            } ?>
                                        </div>
                                        <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                            <i class="fa-solid fa-bars mobile-nav-icon bars"></i>
                                            <i class="fa-solid fa-xmark mobile-nav-icon close"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="col-xl-9 col-lg-9 col-md-12 col-sm-9 pd-0 logocontent">

                                    <div class="row">
                                        <div class="col-lg-12 headericon">
                                            <div class="topheader ">
                                                <div class="d-flex " style="float: right;">
                                                    <div class="col-xl-3 col-lg-3 col-md-3 col-12 laptop">
                                                        <div class="social-links mr-3" style="font-size: 20px;">
                                                            <a
                                                                href="<?php echo esc_url(get_theme_mod('carpenter_wood_works_head_insta_link', '#')); ?>">
                                                                <i class="fa-brands fa-instagram"></i>
                                                            </a>
                                                            <a
                                                                href="<?php echo esc_url(get_theme_mod('carpenter_wood_works_head_pinterest_link', '#')); ?>">
                                                                <i class="fa-brands fa-pinterest-p"></i>
                                                            </a>
                                                            <a
                                                                href="<?php echo esc_url(get_theme_mod('carpenter_wood_works_head_facebook_link', '#')); ?>">
                                                                <i class="fa-brands fa-facebook-f"></i>
                                                            </a>
                                                            <a
                                                                href="<?php echo esc_url(get_theme_mod('carpenter_wood_works_head_twitter_link', '#')); ?>">
                                                                <i class="fa-brands fa-x-twitter"></i>
                                                            </a>
                                                        </div>
                                                    </div>

                                                    <div class="contact-info d-flex d-none d-md-flex">
                                                        <div class="email_info " style="display: contents;">
                                                            <div class="social-links phone">
                                                                <i class="fa-solid fa-phone"></i>
                                                                <div class="">
                                                                    <a
                                                                        href="tel:<?php echo esc_attr(get_theme_mod('carpenter_wood_works_head_phonenumber', '(+00)1233 4566')); ?>">
                                                                        <?php echo esc_html(get_theme_mod('carpenter_wood_works_head_phonenumber', '(+00)1233 4566')); ?>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                            <div class="social-links mail">
                                                                <i class="fa-solid fa-envelope"></i>
                                                                <div class="">
                                                                    <a
                                                                        href="mailto:<?php echo esc_attr(get_theme_mod('carpenter_wood_works_head_mail', 'carpenterwoodworks@demo.com')); ?>">
                                                                        <?php echo esc_html(get_theme_mod('carpenter_wood_works_head_mail', 'carpenterwoodworks@demo.com')); ?>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 " style="position: relative;">
                                            <?php
                                            wp_nav_menu(array(
                                                'theme_location' => 'menu-1',
                                                'menu_id' => 'primary-menu',
                                                'container' => false, // disable default <div class="menu-1-container">
                                                'items_wrap' => '<div class="custom-menu-wrapper"><ul id="%1$s" class="%2$s">%3$s</ul></div>',
                                            ));
                                            ?>
                                            <!-- Search Icon -->
                                            <!-- <div class="search-icon">
                                                <span id="formButton" style="cursor:pointer;"> <svg viewBox="0 0 30 30">
                                                        <path
                                                            d="M13 3C7.49 3 3 7.49 3 13s4.49 10 10 10c2.4 0 4.6-.85 6.32-2.26l5.97 5.97a1 1 0 0 0 1.41-1.41l-5.97-5.97A9.94 9.94 0 0 0 23 13c0-5.51-4.49-10-10-10zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8z" />
                                                    </svg></span>
                                            </div> -->
                                            <div class="search-icon"> 
                                                <button id="formButton" type="button" aria-label="Open Search" style="cursor:pointer; background:none; border:none;">
                                                    <svg viewBox="0 0 30 30" width="24" height="24" aria-hidden="true" focusable="false">
                                                    <path
                                                        d="M13 3C7.49 3 3 7.49 3 13s4.49 10 10 10c2.4 0 4.6-.85 6.32-2.26l5.97 5.97a1 1 0 0 0 1.41-1.41l-5.97-5.97A9.94 9.94 0 0 0 23 13c0-5.51-4.49-10-10-10zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8z" />
                                                    </svg>
                                                </button>
                                            </div>
                                        </div>
                                        <!-- <div class="top-form">
                                            <div id="form1" class="search-overlay">
                                                <div class="search-box">
                                                    <//?php get_search_form(); ?>
                                                    <span id="closeForm" class="close-button"
                                                        aria-label="Close Search">×</span>
                                                </div>
                                            </div>
                                        </div> -->
                                        <div class="top-form">
                                            <div id="form1" class="search-overlay" style="display:none;">
                                                <div class="search-box">
                                                <?php get_search_form(); ?>
                                                <button id="closeForm" class="close-button" type="button" aria-label="Close Search">×</button>
                                                </div>
                                            </div>
                                        </div>
                            </nav><!-- #site-navigation -->
                        </div>
                    </div>
                </div>
            </div>
        </header><!-- #masthead -->