<?php
$carpenter_shop_layout = carpenter_shop_get_final_sidebar_layout();
$carpenter_shop_sidebar_class = 'column-order-1';

if ( $carpenter_shop_layout === 'left-sidebar' ) {
    $carpenter_shop_sidebar_class = 'column-order-1';
} elseif ( $carpenter_shop_layout === 'right-sidebar' ) {
    $carpenter_shop_sidebar_class = 'column-order-2';
}

if ( $carpenter_shop_layout !== 'no-sidebar' ) : ?>
    <aside id="secondary" class="widget-area <?php echo esc_attr( $carpenter_shop_sidebar_class ); ?>">
        <div class="widget-area-wrapper">
            <?php if ( is_active_sidebar('sidebar-1') ) : ?>
                <?php dynamic_sidebar( 'sidebar-1' ); ?>
            <?php else : ?>
                <!-- Default widgets -->
                <div class="widget widget_block widget_search">
                    <h3 class="widget-title"><?php esc_html_e('Search', 'carpenter-shop'); ?></h3>
                    <?php get_search_form(); ?>
                </div>

                <div class="widget widget_pages">
                    <h3 class="widget-title"><?php esc_html_e('Pages', 'carpenter-shop'); ?></h3>
                    <ul>
                        <?php
                        wp_list_pages(array(
                            'title_li' => '',
                        ));
                        ?>
                    </ul>
                </div>

                <div class="widget widget_archive">
                    <h3 class="widget-title"><?php esc_html_e('Archives', 'carpenter-shop'); ?></h3>
                    <ul>
                        <?php wp_get_archives(['type' => 'monthly', 'show_post_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_categories">
                    <h3 class="widget-title"><?php esc_html_e('Categories', 'carpenter-shop'); ?></h3>
                    <ul class="wp-block-categories-list wp-block-categories">
                        <?php wp_list_categories(['orderby' => 'name', 'title_li' => '', 'show_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_tag_cloud">
                    <h3 class="widget-title"><?php esc_html_e('Tags', 'carpenter-shop'); ?></h3>
                    <?php
                    $carpenter_shop_tags = get_tags();
                    if ( $carpenter_shop_tags ) {
                        echo '<div class="tagcloud">';
                        foreach ( $carpenter_shop_tags as $carpenter_shop_tag ) {
                            $carpenter_shop_link = get_tag_link($carpenter_shop_tag->term_id);
                            echo '<a href="' . esc_url($carpenter_shop_link) . '" class="tag-cloud-link">' . esc_html($carpenter_shop_tag->name) . '</a> ';
                        }
                        echo '</div>';
                    } else {
                        echo '<p>' . esc_html__('No tags found.', 'carpenter-shop') . '</p>';
                    }
                    ?>
                </div>

            <?php endif; ?>
        </div>
    </aside>
<?php endif; ?>
