<?php
/**
 *
 * Pagination Functions
 *
 * @package Carpenter Shop
 */

/**
 * Pagination for archive.
 */
function carpenter_shop_render_posts_pagination() {
    // Get the setting to check if pagination is enabled
    $carpenter_shop_is_pagination_enabled = get_theme_mod( 'carpenter_shop_enable_pagination', true );

    // Check if pagination is enabled
    if ( $carpenter_shop_is_pagination_enabled ) {
        // Get the selected pagination type from the Customizer
        $carpenter_shop_pagination_type = get_theme_mod( 'carpenter_shop_theme_pagination_type', 'numeric' );

        // Check if the pagination type is "newer_older" (Previous/Next) or "numeric"
        if ( 'newer_older' === $carpenter_shop_pagination_type ) :
            // Display "Newer/Older" pagination (Previous/Next navigation)
            the_posts_navigation(
                array(
                    'prev_text' => __( '&laquo; Newer', 'carpenter-shop' ),  // Change the label for "previous"
                    'next_text' => __( 'Older &raquo;', 'carpenter-shop' ),  // Change the label for "next"
                    'screen_reader_text' => __( 'Posts navigation', 'carpenter-shop' ),
                )
            );
        else :
            // Display numeric pagination (Page numbers)
            the_posts_pagination(
                array(
                    'prev_text' => __( '&laquo; Previous', 'carpenter-shop' ),
                    'next_text' => __( 'Next &raquo;', 'carpenter-shop' ),
                    'type'      => 'list', // Display as <ul> <li> tags
                    'screen_reader_text' => __( 'Posts navigation', 'carpenter-shop' ),
                )
            );
        endif;
    }
}
add_action( 'carpenter_shop_posts_pagination', 'carpenter_shop_render_posts_pagination', 10 );