<?php
/**
 * Settings for demo import
 *
 */

/**
 * Define constants
 **/
if ( ! defined( 'WHIZZIE_DIR' ) ) {
	define( 'WHIZZIE_DIR', dirname( __FILE__ ) );
}
require trailingslashit( WHIZZIE_DIR ) . 'homepage-setup-contents.php';
$carpenter_shop_current_theme = wp_get_theme();
$carpenter_shop_theme_title = $carpenter_shop_current_theme->get( 'Name' );


/**
 * Make changes below
 **/

// Change the title and slug of your wizard page
$config['carpenter_shop_page_slug'] 	= 'carpenter-shop';
$config['carpenter_shop_page_title']	= 'Homepage Setup';

$config['steps'] = array(
	'plugins' => array(
		'id'			=> 'plugins',
		'title'			=> __( 'Install and Activate Essential Plugins', 'carpenter-shop' ),
		'icon'			=> 'admin-plugins',
		'button_text'	=> __( 'Install Plugins', 'carpenter-shop' ),
		'can_skip'		=> true
	),
	'widgets' => array(
		'id'			=> 'widgets',
		'title'			=> __( 'Setup Home Page', 'carpenter-shop' ),
		'icon'			=> 'welcome-widgets-menus',
		'button_text'	=> __( 'Start Home Page Setup', 'carpenter-shop' ),
		'can_skip'		=> true
	),
	'done' => array(
		'id'			=> 'done',
		'title'			=> __( 'Customize Your Site', 'carpenter-shop' ),
		'icon'			=> 'yes',
	)
);

/**
 * This kicks off the wizard
 **/
if( class_exists( 'Carpenter_Shop_Whizzie' ) ) {
	$Carpenter_Shop_Whizzie = new Carpenter_Shop_Whizzie( $config );
}