<?php

function carpenter_shop_enqueue_fonts() {
    $carpenter_shop_default_font_content = 'roboto';
    $carpenter_shop_default_font_heading = 'roboto';

    $carpenter_shop_font_content = esc_attr(get_theme_mod('carpenter_shop_content_typography_font', $carpenter_shop_default_font_content));
    $carpenter_shop_font_heading = esc_attr(get_theme_mod('carpenter_shop_heading_typography_font', $carpenter_shop_default_font_heading));

    $carpenter_shop_css = '';

    // Always enqueue main font
    $carpenter_shop_css .= '
    :root {
        --font-main: ' . $carpenter_shop_font_content . ', ' . (in_array($carpenter_shop_font_content, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('carpenter-shop-style-font-general', get_template_directory_uri() . '/fonts/' . $carpenter_shop_font_content . '/font.css');

    // Always enqueue header font
    $carpenter_shop_css .= '
    :root {
        --font-head: ' . $carpenter_shop_font_heading . ', ' . (in_array($carpenter_shop_font_heading, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('carpenter-shop-style-font-h', get_template_directory_uri() . '/fonts/' . $carpenter_shop_font_heading . '/font.css');

    // Add inline style
    wp_add_inline_style('carpenter-shop-style-font-general', $carpenter_shop_css);
}
add_action('wp_enqueue_scripts', 'carpenter_shop_enqueue_fonts', 50);