<?php
/**
* Typography Settings.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'carpenter_shop_typography_setting',
	array(
	'title'      => esc_html__( 'Typography Settings', 'carpenter-shop' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'carpenter_shop_theme_option_panel',
	)
);

// -----------------  Font array
$carpenter_shop_fonts = array(
    'Select'           => __('Default Font', 'carpenter-shop'),
    'bad-script' => 'Bad Script',
    'bitter'     => 'Bitter',
    'charis-sil' => 'Charis SIL',
    'cuprum'     => 'Cuprum',
    'exo-2'      => 'Exo 2',
    'jost'       => 'Jost',
    'open-sans'  => 'Open Sans',
    'oswald'     => 'Oswald',
    'play'       => 'Play',
    'roboto'     => 'Roboto',
    'outfit'     => 'Outfit',
    'ubuntu'     => 'Ubuntu',
);

 // -----------------  General text font
 $wp_customize->add_setting( 'carpenter_shop_content_typography_font', array(
    'default'           => 'roboto',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_radio_sanitize',
) );
$wp_customize->add_control( 'carpenter_shop_content_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Content Font', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_typography_setting',
    'settings' => 'carpenter_shop_content_typography_font',
    'choices'  => $carpenter_shop_fonts,
) );

 // -----------------  General Heading Font
$wp_customize->add_setting( 'carpenter_shop_heading_typography_font', array(
    'default'           => 'roboto',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_radio_sanitize',
) );
$wp_customize->add_control( 'carpenter_shop_heading_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Heading Font', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_typography_setting',
    'settings' => 'carpenter_shop_heading_typography_font',
    'choices'  => $carpenter_shop_fonts,
) );