<?php
/**
* Custom Functions.
*
* @package Carpenter Shop
*/

if( !function_exists( 'carpenter_shop_sanitize_sidebar_option' ) ) :

    // Sidebar Option Sanitize.
    function carpenter_shop_sanitize_sidebar_option( $carpenter_shop_input ){

        $carpenter_shop_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $carpenter_shop_input,$carpenter_shop_metabox_options ) ){

            return $carpenter_shop_input;

        }

        return;

    }

endif;

if ( ! function_exists( 'carpenter_shop_sanitize_checkbox' ) ) :

	/**
	 * Sanitize checkbox.
	 */
	function carpenter_shop_sanitize_checkbox( $carpenter_shop_checked ) {

		return ( ( isset( $carpenter_shop_checked ) && true === $carpenter_shop_checked ) ? true : false );

	}

endif;


if ( ! function_exists( 'carpenter_shop_sanitize_select' ) ) :

    /**
     * Sanitize select.
     */
    function carpenter_shop_sanitize_select( $carpenter_shop_input, $carpenter_shop_setting ) {
        $carpenter_shop_input = sanitize_text_field( $carpenter_shop_input );
        $choices = $carpenter_shop_setting->manager->get_control( $carpenter_shop_setting->id )->choices;
        return ( array_key_exists( $carpenter_shop_input, $choices ) ? $carpenter_shop_input : $carpenter_shop_setting->default );
    }

endif;

if( !function_exists( 'carpenter_shop_sanitize_pagination_type' ) ) :

    /**
     * Sanitize the pagination type setting.
     *
     * @param string $carpenter_shop_input The input value from the Customizer.
     * @return string The sanitized value.
     */
    function carpenter_shop_sanitize_pagination_type( $carpenter_shop_input ) {
        // Define valid options for the pagination type.
        $carpenter_shop_valid_options = array( 'numeric', 'newer_older' ); // Update valid options to include 'newer_older'

        // If the input is one of the valid options, return it. Otherwise, return the default option ('numeric').
        if ( in_array( $carpenter_shop_input, $carpenter_shop_valid_options, true ) ) {
            return $carpenter_shop_input;
        } else {
            // Return 'numeric' as the fallback if the input is invalid.
            return 'numeric';
        }
    }

endif;


// Sanitize the enable/disable setting for pagination
if( !function_exists('carpenter_shop_sanitize_enable_pagination') ) :
    function carpenter_shop_sanitize_enable_pagination( $carpenter_shop_input ) {
        return (bool) $carpenter_shop_input;
    }
endif;

if( !function_exists( 'carpenter_shop_sanitize_pagination_meta' ) ) :

    // Sidebar Option Sanitize.
    function carpenter_shop_sanitize_pagination_meta( $carpenter_shop_input ){

        $carpenter_shop_metabox_options = array( 'Center','Right','Left');
        if( in_array( $carpenter_shop_input,$carpenter_shop_metabox_options ) ){

            return $carpenter_shop_input;

        }else{

            return '';

        }
    }

endif;