<?php
/**
* Posts Settings.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

// Single Post Section.
$wp_customize->add_section( 'carpenter_shop_single_posts_settings',
    array(
    'title'      => esc_html__( 'Single Meta Information Settings', 'carpenter-shop' ),
    'priority'   => 35,
    'capability' => 'edit_theme_options',
    'panel'      => 'carpenter_shop_theme_option_panel',
    )
);

$wp_customize->add_setting('carpenter_shop_display_single_post_image',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_display_single_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_display_single_post_image',
    array(
        'label' => esc_html__('Enable Single Posts Image', 'carpenter-shop'),
        'section' => 'carpenter_shop_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_post_author',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_post_author'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_post_author',
    array(
        'label' => esc_html__('Enable Posts Author', 'carpenter-shop'),
        'section' => 'carpenter_shop_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_post_date',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_post_date'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_post_date',
    array(
        'label' => esc_html__('Enable Posts Date', 'carpenter-shop'),
        'section' => 'carpenter_shop_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_post_category',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'carpenter-shop'),
        'section' => 'carpenter_shop_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_post_tags',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_post_tags'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_post_tags',
    array(
        'label' => esc_html__('Enable Posts Tags', 'carpenter-shop'),
        'section' => 'carpenter_shop_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'carpenter_shop_single_page_content_alignment',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_single_page_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'carpenter_shop_single_page_content_alignment',
    array(
    'label'       => esc_html__( 'Single Page Content Alignment', 'carpenter-shop' ),
    'section'     => 'carpenter_shop_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'carpenter-shop' ),
        'center'  => esc_html__( 'Center', 'carpenter-shop' ),
        'right'    => esc_html__( 'Right', 'carpenter-shop' ),
        ),
    )
);

$wp_customize->add_setting( 'carpenter_shop_single_post_content_alignment',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_single_post_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'carpenter_shop_single_post_content_alignment',
    array(
    'label'       => esc_html__( 'Single Post Content Alignment', 'carpenter-shop' ),
    'section'     => 'carpenter_shop_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'carpenter-shop' ),
        'center'  => esc_html__( 'Center', 'carpenter-shop' ),
        'right'    => esc_html__( 'Right', 'carpenter-shop' ),
        ),
    )
);

// Archive Post Section.
$wp_customize->add_section( 'carpenter_shop_posts_settings',
    array(
    'title'      => esc_html__( 'Archive Meta Information Settings', 'carpenter-shop' ),
    'priority'   => 36,
    'capability' => 'edit_theme_options',
    'panel'      => 'carpenter_shop_theme_option_panel',
    )
);

$wp_customize->add_setting('carpenter_shop_display_archive_post_format_icon',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_display_archive_post_format_icon'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_display_archive_post_format_icon',
    array(
        'label' => esc_html__('Enable Posts Format Icon', 'carpenter-shop'),
        'section' => 'carpenter_shop_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_display_archive_post_image',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_display_archive_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_display_archive_post_image',
    array(
        'label' => esc_html__('Enable Posts Image', 'carpenter-shop'),
        'section' => 'carpenter_shop_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_display_archive_post_category',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_display_archive_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_display_archive_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'carpenter-shop'),
        'section' => 'carpenter_shop_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_display_archive_post_title',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_display_archive_post_title'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_display_archive_post_title',
    array(
        'label' => esc_html__('Enable Posts Title', 'carpenter-shop'),
        'section' => 'carpenter_shop_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_display_archive_post_content',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_display_archive_post_content'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_display_archive_post_content',
    array(
        'label' => esc_html__('Enable Posts Content', 'carpenter-shop'),
        'section' => 'carpenter_shop_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_display_archive_post_button',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_display_archive_post_button'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_display_archive_post_button',
    array(
        'label' => esc_html__('Enable Posts Button', 'carpenter-shop'),
        'section' => 'carpenter_shop_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_excerpt_limit',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_excerpt_limit'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
    )
);
$wp_customize->add_control('carpenter_shop_excerpt_limit',
    array(
        'label'       => esc_html__('Blog Posts Excerpt limit', 'carpenter-shop'),
        'section'     => 'carpenter_shop_posts_settings',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 100,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'carpenter_shop_archive_image_size',
	array(
	'default'           => 'medium',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'carpenter_shop_sanitize_select',
	)
);
$wp_customize->add_control( 'carpenter_shop_archive_image_size',
	array(
	'label'       => esc_html__( 'Blog Posts Image Size', 'carpenter-shop' ),
	'section'     => 'carpenter_shop_posts_settings',
	'type'        => 'select',
	'choices'               => array(
		'full' => esc_html__( 'Large Size Image', 'carpenter-shop' ),
		'large' => esc_html__( 'Big Size Image', 'carpenter-shop' ),
		'medium' => esc_html__( 'Medium Size Image', 'carpenter-shop' ),
		'small' => esc_html__( 'Small Size Image', 'carpenter-shop' ),
		'xsmall' => esc_html__( 'Extra Small Size Image', 'carpenter-shop' ),
		'thumbnail' => esc_html__( 'Thumbnail Size Image', 'carpenter-shop' ),
	    ),
	)
);

$wp_customize->add_setting('carpenter_shop_posts_per_columns',
    array(
    'default'           => '3',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
    )
);
$wp_customize->add_control('carpenter_shop_posts_per_columns',
    array(
    'label'       => esc_html__('Blog Posts Per Column', 'carpenter-shop'),
    'section'     => 'carpenter_shop_posts_settings',
    'type'        => 'number',
    'input_attrs' => array(
    'min'   => 1,
    'max'   => 5,
    'step'   => 1,
    ),
    )
);