<?php
/**
* Noting Found Page Settings.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

$wp_customize->add_section( 'carpenter_shop_noting_found_page_settings',
    array(
        'title'      => esc_html__( 'Nothing Found Page Settings', 'carpenter-shop' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'carpenter_shop_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'carpenter_shop_noting_found_main_title',
    array(
        'default'           => 'Nothing Found',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_noting_found_main_title',
    array(
        'label'    => esc_html__( 'Main Title', 'carpenter-shop' ),
        'section'  => 'carpenter_shop_noting_found_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'carpenter_shop_noting_found_para',
    array(
        'default'           => 'Sorry, but nothing matched your search terms. Please try again with some different keywords.',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_noting_found_para',
    array(
        'label'    => esc_html__( 'Para Text', 'carpenter-shop' ),
        'section'  => 'carpenter_shop_noting_found_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting('carpenter_shop_noting_found_saerch',
    array(
        'default' => 1,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_noting_found_saerch',
    array(
        'label' => esc_html__('Enable/Disable Search', 'carpenter-shop'),
        'section' => 'carpenter_shop_noting_found_page_settings',
        'type' => 'checkbox',
    )
);