<?php
/**
* Layouts Settings.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'carpenter_shop_layout_setting',
	array(
	'title'      => esc_html__( 'Sidebar Settings', 'carpenter-shop' ),
	'priority'   => 20,
	'capability' => 'edit_theme_options',
	'panel'      => 'carpenter_shop_theme_option_panel',
	)
);

$wp_customize->add_setting( 'carpenter_shop_global_sidebar_layout',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_sidebar_option',
    )
);
$wp_customize->add_control( 'carpenter_shop_global_sidebar_layout',
    array(
    'label'       => esc_html__( 'Global Sidebar Layout', 'carpenter-shop' ),
    'section'     => 'carpenter_shop_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__( 'Right Sidebar', 'carpenter-shop' ),
        'left-sidebar'  => esc_html__( 'Left Sidebar', 'carpenter-shop' ),
        'no-sidebar'    => esc_html__( 'No Sidebar', 'carpenter-shop' ),
        ),
    )
);

$wp_customize->add_setting('carpenter_shop_page_sidebar_layout', array(
    'default'           => $carpenter_shop_default['carpenter_shop_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_sidebar_option',
));

$wp_customize->add_control('carpenter_shop_page_sidebar_layout', array(
    'label'       => esc_html__('Single Page Sidebar Layout', 'carpenter-shop'),
    'section'     => 'carpenter_shop_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'carpenter-shop'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'carpenter-shop'),
        'no-sidebar'    => esc_html__('No Sidebar', 'carpenter-shop'),
    ),
));

$wp_customize->add_setting('carpenter_shop_post_sidebar_layout', array(
    'default'           => $carpenter_shop_default['carpenter_shop_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_sidebar_option',
));

$wp_customize->add_control('carpenter_shop_post_sidebar_layout', array(
    'label'       => esc_html__('Single Post Sidebar Layout', 'carpenter-shop'),
    'section'     => 'carpenter_shop_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'carpenter-shop'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'carpenter-shop'),
        'no-sidebar'    => esc_html__('No Sidebar', 'carpenter-shop'),
    ),
));

$wp_customize->add_setting('carpenter_shop_sticky_sidebar',
    array(
        'default'           => true,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_sticky_sidebar',
    array(
        'label' => esc_html__('Enable/Disable Sticky Sidebar', 'carpenter-shop'),
        'section' => 'carpenter_shop_layout_setting',
        'type' => 'checkbox',
    )
);