<?php
/**
* Header Options.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

// Header Section.
$wp_customize->add_section( 'carpenter_shop_button_header_setting',
	array(
	'title'      => esc_html__( 'Header Settings', 'carpenter-shop' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	'panel'      => 'carpenter_shop_theme_option_panel',
	)
);

$wp_customize->add_setting( 'carpenter_shop_header_layout_topbar_text',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_header_layout_topbar_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_header_layout_topbar_text',
    array(
    'label'    => esc_html__( 'Header Text', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'carpenter_shop_header_layout_wishlist_text',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_header_layout_wishlist_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_header_layout_wishlist_text',
    array(
    'label'    => esc_html__( 'Wishlist Text', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'carpenter_shop_header_layout_wishlist_link',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_header_layout_wishlist_link'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'carpenter_shop_header_layout_wishlist_link',
    array(
    'label'    => esc_html__( 'Wishlist Link', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_button_header_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting( 'carpenter_shop_header_layout_compare_text',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_header_layout_compare_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_header_layout_compare_text',
    array(
    'label'    => esc_html__( 'Compare Text', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'carpenter_shop_header_layout_compare_link',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_header_layout_compare_link'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'carpenter_shop_header_layout_compare_link',
    array(
    'label'    => esc_html__( 'Compare Link', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_button_header_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting( 'carpenter_shop_header_layout_phone_number',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_header_layout_phone_number'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_header_layout_phone_number',
    array(
    'label'    => esc_html__( 'Header Phone Number', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting('carpenter_shop_sticky',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_sticky'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_sticky',
    array(
        'label' => esc_html__('Enable Sticky Header', 'carpenter-shop'),
        'section' => 'carpenter_shop_button_header_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('carpenter_shop_menu_font_size',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_menu_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
    )
);
$wp_customize->add_control('carpenter_shop_menu_font_size',
    array(
        'label'       => esc_html__('Menu Font Size', 'carpenter-shop'),
        'section'     => 'carpenter_shop_button_header_setting',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 30,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'carpenter_shop_menu_text_transform',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_menu_text_transform'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_menu_transform',
    )
);
$wp_customize->add_control( 'carpenter_shop_menu_text_transform',
    array(
    'label'       => esc_html__( 'Menu Text Transform', 'carpenter-shop' ),
    'section'     => 'carpenter_shop_button_header_setting',
    'type'        => 'select',
    'choices'     => array(
        'capitalize' => esc_html__( 'Capitalize', 'carpenter-shop' ),
        'uppercase'  => esc_html__( 'Uppercase', 'carpenter-shop' ),
        'lowercase'    => esc_html__( 'Lowercase', 'carpenter-shop' ),
        ),
    )
);

$wp_customize->add_setting('carpenter_shop_header_menus_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'carpenter_shop_header_menus_color', array(
    'label'    => __('Main Menu Color', 'carpenter-shop'),
    'section'  => 'carpenter_shop_button_header_setting',
)));

$wp_customize->add_setting('carpenter_shop_header_menus_hover_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'carpenter_shop_header_menus_hover_color', array(
    'label'    => __('Main Menu Hover Color', 'carpenter-shop'),
    'section'  => 'carpenter_shop_button_header_setting',
)));

$wp_customize->add_setting('carpenter_shop_header_submenus_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'carpenter_shop_header_submenus_color', array(
    'label'    => __('Submenu Color', 'carpenter-shop'),
    'section'  => 'carpenter_shop_button_header_setting',
)));

$wp_customize->add_setting('carpenter_shop_header_submenus_hover_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'carpenter_shop_header_submenus_hover_color', array(
    'label'    => __('Submenu Hover Color', 'carpenter-shop'),
    'section'  => 'carpenter_shop_button_header_setting',
)));