<?php
/**
* Global Color Settings.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'carpenter_shop_global_color_setting',
	array(
	'title'      => esc_html__( 'Global Color Settings', 'carpenter-shop' ),
	'priority'   => 1,
	'capability' => 'edit_theme_options',
	'panel'      => 'carpenter_shop_theme_option_panel',
	)
);

$wp_customize->add_setting( 'carpenter_shop_global_color',
    array(
    'default'           => '#7C5E30',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'carpenter_shop_global_color',
    array(
        'label'      => esc_html__( 'Global Color', 'carpenter-shop' ),
        'section'    => 'carpenter_shop_global_color_setting',
        'settings'   => 'carpenter_shop_global_color',
    ) ) 
);

$wp_customize->add_setting( 'carpenter_shop_second_color',
    array(
    'default'           => '#FFCCB0',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'carpenter_shop_second_color',
    array(
        'label'      => esc_html__( 'Global Color', 'carpenter-shop' ),
        'section'    => 'carpenter_shop_global_color_setting',
        'settings'   => 'carpenter_shop_second_color',
    ) ) 
);