<?php
/**
* Footer Settings.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

$wp_customize->add_section( 'carpenter_shop_footer_widget_area',
	array(
	'title'      => esc_html__( 'Footer Settings', 'carpenter-shop' ),
	'priority'   => 200,
	'capability' => 'edit_theme_options',
	'panel'      => 'carpenter_shop_theme_option_panel',
	)
);

$wp_customize->add_setting('carpenter_shop_display_footer',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_display_footer'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_display_footer',
    array(
        'label' => esc_html__('Enable Footer', 'carpenter-shop'),
        'section' => 'carpenter_shop_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'carpenter_shop_footer_column_layout',
	array(
	'default'           => $carpenter_shop_default['carpenter_shop_footer_column_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'carpenter_shop_sanitize_select',
	)
);
$wp_customize->add_control( 'carpenter_shop_footer_column_layout',
	array(
	'label'       => esc_html__( 'Footer Column Layout', 'carpenter-shop' ),
	'section'     => 'carpenter_shop_footer_widget_area',
	'type'        => 'select',
	'choices'               => array(
		'1' => esc_html__( 'One Column', 'carpenter-shop' ),
		'2' => esc_html__( 'Two Column', 'carpenter-shop' ),
		'3' => esc_html__( 'Three Column', 'carpenter-shop' ),
	    ),
	)
);

$wp_customize->add_setting( 'carpenter_shop_footer_widget_title_alignment',
        array(
        'default'           => $carpenter_shop_default['carpenter_shop_footer_widget_title_alignment'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_footer_widget_title_alignment',
        )
);
$wp_customize->add_control( 'carpenter_shop_footer_widget_title_alignment',
    array(
    'label'       => esc_html__( 'Footer Widget Title Alignment', 'carpenter-shop' ),
    'section'     => 'carpenter_shop_footer_widget_area',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'carpenter-shop' ),
        'center'  => esc_html__( 'Center', 'carpenter-shop' ),
        'right'    => esc_html__( 'Right', 'carpenter-shop' ),
        ),
    )
);

$wp_customize->add_setting( 'carpenter_shop_footer_copyright_text',
	array(
	'default'           => $carpenter_shop_default['carpenter_shop_footer_copyright_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'carpenter_shop_footer_copyright_text',
	array(
	'label'    => esc_html__( 'Footer Copyright Text', 'carpenter-shop' ),
	'section'  => 'carpenter_shop_footer_widget_area',
	'type'     => 'text',
	)
);

$wp_customize->add_setting('carpenter_shop_copyright_font_size',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_copyright_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
    )
);
$wp_customize->add_control('carpenter_shop_copyright_font_size',
    array(
        'label'       => esc_html__('Copyright Font Size', 'carpenter-shop'),
        'section'     => 'carpenter_shop_footer_widget_area',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 5,
           'max'   => 30,
           'step'   => 1,
    	),
    )
);

$wp_customize->add_setting( 'carpenter_shop_copyright_alignment', array(
    'default'           => 'Default',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_copyright_alignment_meta',
) );

$wp_customize->add_control( 'carpenter_shop_copyright_alignment', array(
    'label'    => esc_html__( 'Copyright Section Alignment', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_footer_widget_area',
    'type'     => 'select',
    'choices'  => array(
        'Default' => esc_html__( 'Default View', 'carpenter-shop' ),
        'Reverse' => esc_html__( 'Reverse View', 'carpenter-shop' ),
        'Center'  => esc_html__( 'Centered Content', 'carpenter-shop' ),
    ),
) );

$wp_customize->add_setting( 'carpenter_shop_footer_widget_background_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'carpenter_shop_footer_widget_background_color', array(
    'label'     => __('Footer Widget Background Color', 'carpenter-shop'),
    'description' => __('It will change the complete footer widget background color.', 'carpenter-shop'),
    'section' => 'carpenter_shop_footer_widget_area',
    'settings' => 'carpenter_shop_footer_widget_background_color',
)));

$wp_customize->add_setting('carpenter_shop_footer_widget_background_image',array(
    'default'   => '',
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'carpenter_shop_footer_widget_background_image',array(
    'label' => __('Footer Widget Background Image','carpenter-shop'),
    'section' => 'carpenter_shop_footer_widget_area'
)));

$wp_customize->add_setting('carpenter_shop_enable_to_the_top',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_enable_to_the_top'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_enable_to_the_top',
    array(
        'label' => esc_html__('Enable To The Top', 'carpenter-shop'),
        'section' => 'carpenter_shop_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'carpenter_shop_to_the_top_text',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_to_the_top_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_to_the_top_text',
    array(
    'label'    => esc_html__( 'Edit Text Here', 'carpenter-shop' ),
    'section'  => 'carpenter_shop_footer_widget_area',
    'type'     => 'text',
    )
);