<?php
/**
 * Default Values.
 *
 * @package Carpenter Shop
 */

if ( ! function_exists( 'carpenter_shop_get_default_theme_options' ) ) :
	function carpenter_shop_get_default_theme_options() {

		$carpenter_shop_defaults = array();
		
		// Options.
        $carpenter_shop_defaults['carpenter_shop_logo_width_range']                                  = 200;
		$carpenter_shop_defaults['carpenter_shop_global_sidebar_layout']					            = 'right-sidebar';

        $carpenter_shop_defaults['carpenter_shop_header_layout_topbar_text']      = esc_html__( 'Fast Austrelia Wide Shipping & support@example.com', 'carpenter-shop' );


        $carpenter_shop_defaults['carpenter_shop_header_layout_wishlist_text']      = esc_html__( 'Wishlist', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_header_layout_wishlist_link']      = esc_url( 'https://www.google.com/', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_header_layout_compare_text']      = esc_html__( 'Compare', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_header_layout_compare_link']      = esc_url( 'https://www.google.com/', 'carpenter-shop' );
            
        $carpenter_shop_defaults['carpenter_shop_header_layout_phone_number']       = '+11 231 456 7890';

        $carpenter_shop_defaults['carpenter_shop_theme_loader']                  = 0;
        $carpenter_shop_defaults['carpenter_shop_theme_breadcrumb_enable']                 = 1;
        $carpenter_shop_defaults['carpenter_shop_single_post_content_alignment']                 = 'left';

        $carpenter_shop_defaults['carpenter_shop_homepage_section_shipping_title']      = esc_html__( 'Free Shipping', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_homepage_section_shipping_text']      = esc_html__( 'Free Delivery Worldwide', 'carpenter-shop' );

        $carpenter_shop_defaults['carpenter_shop_homepage_section_exchange_title']      = esc_html__( 'Return Exchange', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_homepage_section_exchange_text']       = esc_html__( 'Return Exchange 20 Days', 'carpenter-shop' );

        $carpenter_shop_defaults['carpenter_shop_homepage_section_support_title']      = esc_html__( 'Quality Support', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_homepage_section_support_text']       = esc_html__( 'Free Support Online 24/7', 'carpenter-shop' );

        $carpenter_shop_defaults['carpenter_shop_homepage_section_shopping_title']      = esc_html__( 'Safe Shopping', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_homepage_section_shopping_text']       = esc_html__( 'Ensure Genuine 100%', 'carpenter-shop' );

        $carpenter_shop_defaults['carpenter_shop_pagination_layout']         = 'numeric';
		$carpenter_shop_defaults['carpenter_shop_footer_column_layout'] 						 = 3;
		$carpenter_shop_defaults['carpenter_shop_footer_copyright_text'] 				     = esc_html__( 'All rights reserved.', 'carpenter-shop' );
        $carpenter_shop_defaults['twp_navigation_type']              			 = 'theme-normal-navigation';
        $carpenter_shop_defaults['carpenter_shop_post_author']                		= 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_sticky_post']            = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_category']            = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_title']            = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_content']            = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_button']            = 1;
        $carpenter_shop_defaults['carpenter_shop_post_date']                		= 1;
        $carpenter_shop_defaults['carpenter_shop_post_category']                	= 1;
        $carpenter_shop_defaults['carpenter_shop_post_tags']                		= 1;
        $carpenter_shop_defaults['carpenter_shop_floating_next_previous_nav']       = 1;
        $carpenter_shop_defaults['carpenter_shop_header_banner']               		= 1;
        $carpenter_shop_defaults['carpenter_shop_display_header_title']        = 1;
        $carpenter_shop_defaults['carpenter_shop_product_section']                  = 1;
        $carpenter_shop_defaults['carpenter_shop_sticky']                 = 0;

        $carpenter_shop_defaults['carpenter_shop_product_heading']      = esc_html__( 'Featured Products', 'carpenter-shop' );

        $carpenter_shop_defaults['carpenter_shop_product_button_text']      = esc_html__( 'View All', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_product_button_link']      = esc_url( 'https://www.google.com/', 'carpenter-shop' );
        
        $carpenter_shop_defaults['carpenter_shop_background_color']               	= '#fff';
        $carpenter_shop_defaults['carpenter_shop_copyright_font_size']                 = 16;
        $carpenter_shop_defaults['carpenter_shop_footer_widget_title_alignment']                  = 'left'; 
        $carpenter_shop_defaults['carpenter_shop_display_footer']                                 = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_category']          = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_title']             = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_content']           = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_button']            = 1;
        
        $carpenter_shop_defaults['carpenter_shop_display_single_post_image']            = 1;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_format_icon']       = 1;

        $carpenter_shop_defaults['carpenter_shop_menu_text_transform']                 = 'capitalize';  
        $carpenter_shop_defaults['carpenter_shop_single_page_content_alignment']                 = 'left';
        $carpenter_shop_defaults['carpenter_shop_theme_pagination_options_alignment']                 = 'Center'; 
        $carpenter_shop_defaults['carpenter_shop_theme_breadcrumb_options_alignment']                 = 'Left'; 
        $carpenter_shop_defaults['carpenter_shop_per_columns']                 = 3;  
        $carpenter_shop_defaults['carpenter_shop_product_per_page']                 = 9;
        $carpenter_shop_defaults['carpenter_shop_custom_related_products_number'] = 6;
        $carpenter_shop_defaults['carpenter_shop_custom_related_products_number_per_row'] = 3;
        $carpenter_shop_defaults['carpenter_shop_menu_font_size']                 = 14;
        $carpenter_shop_defaults['carpenter_shop_copyright_font_size']                 = 16;
        $carpenter_shop_defaults['carpenter_shop_breadcrumb_font_size']                 = 16;
        $carpenter_shop_defaults['carpenter_shop_display_archive_post_image']            = 1;
        $carpenter_shop_defaults['carpenter_shop_show_hide_related_product']                      = 1;
        $carpenter_shop_defaults['carpenter_shop_excerpt_limit']                 = 20;

        $carpenter_shop_defaults['carpenter_shop_enable_to_the_top']                      = 1;
        $carpenter_shop_defaults['carpenter_shop_to_the_top_text']                      = esc_html__( 'To The Top', 'carpenter-shop' );

        // 404 Page Defaults
        $carpenter_shop_defaults['carpenter_shop_404_main_title'] = esc_html__( 'Oops! That page can’t be found.', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_404_subtitle_one'] = esc_html__( 'Maybe it’s out there, somewhere...', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_404_para_one'] = esc_html__( 'You can always find insightful stories on our', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_404_subtitle_two'] = esc_html__( 'Still feeling lost? You’re not alone.', 'carpenter-shop' );
        $carpenter_shop_defaults['carpenter_shop_404_para_two'] = esc_html__( 'Enjoy these stories about getting lost, losing things, and finding what you never knew you were looking for.', 'carpenter-shop' );


		// Pass through filter.
		$carpenter_shop_defaults = apply_filters( 'carpenter_shop_filter_default_theme_options', $carpenter_shop_defaults );

		return $carpenter_shop_defaults;
	}
endif;