<?php
/**
* Custom Addons.
*
* @package Carpenter Shop
*/

$wp_customize->add_section( 'carpenter_shop_theme_pagination_options',
    array(
    'title'      => esc_html__( 'Customizer Custom Settings', 'carpenter-shop' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'carpenter_shop_theme_addons_panel',
    )
);

$wp_customize->add_setting('carpenter_shop_theme_loader',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_theme_loader'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
);
$wp_customize->add_control('carpenter_shop_theme_loader',
    array(
        'label' => esc_html__('Enable Preloader', 'carpenter-shop'),
        'section' => 'carpenter_shop_theme_pagination_options',
        'type' => 'checkbox',
    )
);

// Add Pagination Enable/Disable option to Customizer
$wp_customize->add_setting( 'carpenter_shop_enable_pagination', 
    array(
        'default'           => true, // Default is enabled
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_enable_pagination', // Sanitize the input
    )
);

// Add the control to the Customizer
$wp_customize->add_control( 'carpenter_shop_enable_pagination', 
    array(
        'label'    => esc_html__( 'Enable Pagination', 'carpenter-shop' ),
        'section'  => 'carpenter_shop_theme_pagination_options', // Add to the correct section
        'type'     => 'checkbox',
    )
);

$wp_customize->add_setting( 'carpenter_shop_theme_pagination_type', 
    array(
        'default'           => 'numeric', // Set "numeric" as the default
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_pagination_type', // Use our sanitize function
    )
);

$wp_customize->add_control( 'carpenter_shop_theme_pagination_type',
    array(
        'label'       => esc_html__( 'Pagination Style', 'carpenter-shop' ),
        'section'     => 'carpenter_shop_theme_pagination_options',
        'type'        => 'select',
        'choices'     => array(
            'numeric'      => esc_html__( 'Numeric (Page Numbers)', 'carpenter-shop' ),
            'newer_older'  => esc_html__( 'Newer/Older (Previous/Next)', 'carpenter-shop' ), // Renamed to "Newer/Older"
        ),
    )
);
$wp_customize->add_setting( 'carpenter_shop_theme_pagination_options_alignment',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_theme_pagination_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'carpenter_shop_theme_pagination_options_alignment',
    array(
    'label'       => esc_html__( 'Pagination Alignment', 'carpenter-shop' ),
    'section'     => 'carpenter_shop_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'carpenter-shop' ),
        'Right' => esc_html__( 'Right', 'carpenter-shop' ),
        'Left'  => esc_html__( 'Left', 'carpenter-shop' ),
        ),
    )
);

$wp_customize->add_setting('carpenter_shop_theme_breadcrumb_enable',
array(
    'default' => $carpenter_shop_default['carpenter_shop_theme_breadcrumb_enable'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
)
);
$wp_customize->add_control('carpenter_shop_theme_breadcrumb_enable',
    array(
        'label' => esc_html__('Enable Breadcrumb', 'carpenter-shop'),
        'section' => 'carpenter_shop_theme_pagination_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'carpenter_shop_theme_breadcrumb_options_alignment',
    array(
    'default'           => $carpenter_shop_default['carpenter_shop_theme_breadcrumb_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'carpenter_shop_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'carpenter_shop_theme_breadcrumb_options_alignment',
    array(
    'label'       => esc_html__( 'Breadcrumb Alignment', 'carpenter-shop' ),
    'section'     => 'carpenter_shop_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'carpenter-shop' ),
        'Right' => esc_html__( 'Right', 'carpenter-shop' ),
        'Left'  => esc_html__( 'Left', 'carpenter-shop' ),
        ),
    )
);

$wp_customize->add_setting('carpenter_shop_breadcrumb_font_size',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_breadcrumb_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
    )
);
$wp_customize->add_control('carpenter_shop_breadcrumb_font_size',
    array(
        'label'       => esc_html__('Breadcrumb Font Size', 'carpenter-shop'),
        'section'     => 'carpenter_shop_theme_pagination_options',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 45,
           'step'   => 1,
        ),
    )
);