<?php
/**
* Additional Woocommerce Settings.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

// Additional Woocommerce Section.
$wp_customize->add_section( 'carpenter_shop_additional_woocommerce_options',
	array(
	'title'      => esc_html__( 'Additional Woocommerce Options', 'carpenter-shop' ),
	'priority'   => 210,
	'capability' => 'edit_theme_options',
	'panel'      => 'carpenter_shop_theme_option_panel',
	)
);

	$wp_customize->add_setting('carpenter_shop_per_columns',
		array(
		'default'           => $carpenter_shop_default['carpenter_shop_per_columns'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
		)
	);
	$wp_customize->add_control('carpenter_shop_per_columns',
		array(
		'label'       => esc_html__('Products Per Column', 'carpenter-shop'),
		'section'     => 'carpenter_shop_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 6,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('carpenter_shop_product_per_page',
		array(
		'default'           => $carpenter_shop_default['carpenter_shop_product_per_page'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
		)
	);
	$wp_customize->add_control('carpenter_shop_product_per_page',
		array(
		'label'       => esc_html__('Products Per Page', 'carpenter-shop'),
		'section'     => 'carpenter_shop_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 100,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('carpenter_shop_show_hide_related_product',
    array(
        'default' => $carpenter_shop_default['carpenter_shop_show_hide_related_product'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'carpenter_shop_sanitize_checkbox',
    )
	);
	$wp_customize->add_control('carpenter_shop_show_hide_related_product',
	    array(
	        'label' => esc_html__('Enable Related Products', 'carpenter-shop'),
	        'section' => 'carpenter_shop_additional_woocommerce_options',
	        'type' => 'checkbox',
	    )
	);

	$wp_customize->add_setting('carpenter_shop_custom_related_products_number',
		array(
		'default'           => $carpenter_shop_default['carpenter_shop_custom_related_products_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
		)
	);
	$wp_customize->add_control('carpenter_shop_custom_related_products_number',
		array(
		'label'       => esc_html__('Related Products Per Page', 'carpenter-shop'),
		'section'     => 'carpenter_shop_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 10,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('carpenter_shop_custom_related_products_number_per_row',
		array(
		'default'           => $carpenter_shop_default['carpenter_shop_custom_related_products_number_per_row'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'carpenter_shop_sanitize_number_range',
		)
	);
	$wp_customize->add_control('carpenter_shop_custom_related_products_number_per_row',
		array(
		'label'       => esc_html__('Related Products Per Row', 'carpenter-shop'),
		'section'     => 'carpenter_shop_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 5,
		'step'   => 1,
		),
		)
	);