<?php
/**
* 404 Page Settings.
*
* @package Carpenter Shop
*/

$carpenter_shop_default = carpenter_shop_get_default_theme_options();

$wp_customize->add_section( 'carpenter_shop_404_page_settings',
    array(
        'title'      => esc_html__( '404 Page Settings', 'carpenter-shop' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'carpenter_shop_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'carpenter_shop_404_main_title',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_404_main_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_404_main_title',
    array(
        'label'    => esc_html__( '404 Main Title', 'carpenter-shop' ),
        'section'  => 'carpenter_shop_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'carpenter_shop_404_subtitle_one',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_404_subtitle_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_404_subtitle_one',
    array(
        'label'    => esc_html__( '404 Sub Title One', 'carpenter-shop' ),
        'section'  => 'carpenter_shop_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'carpenter_shop_404_para_one',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_404_para_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_404_para_one',
    array(
        'label'    => esc_html__( '404 Para Text One', 'carpenter-shop' ),
        'section'  => 'carpenter_shop_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'carpenter_shop_404_subtitle_two',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_404_subtitle_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_404_subtitle_two',
    array(
        'label'    => esc_html__( '404 Sub Title Two', 'carpenter-shop' ),
        'section'  => 'carpenter_shop_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'carpenter_shop_404_para_two',
    array(
        'default'           => $carpenter_shop_default['carpenter_shop_404_para_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'carpenter_shop_404_para_two',
    array(
        'label'    => esc_html__( '404 Para Text Two', 'carpenter-shop' ),
        'section'  => 'carpenter_shop_404_page_settings',
        'type'     => 'text',
    )
);