<?php
/**
 * Custom page walker for this theme.
 *
 * @package Carpenter Shop
 */

if (!class_exists('Carpenter_Shop_Walker_Page')) {
    /**
     * CUSTOM PAGE WALKER
     * A custom walker for pages.
     */
    class Carpenter_Shop_Walker_Page extends Walker_Page
    {

        /**
         * Outputs the beginning of the current element in the tree.
         *
         * @param string $carpenter_shop_output Used to append additional content. Passed by reference.
         * @param WP_Post $page Page data object.
         * @param int $carpenter_shop_depth Optional. Depth of page. Used for padding. Default 0.
         * @param array $carpenter_shop_args Optional. Array of arguments. Default empty array.
         * @param int $current_page Optional. Page ID. Default 0.
         * @since 2.1.0
         *
         * @see Walker::start_el()
         */

        public function start_lvl( &$carpenter_shop_output, $carpenter_shop_depth = 0, $carpenter_shop_args = array() ) {
            $carpenter_shop_indent  = str_repeat( "\t", $carpenter_shop_depth );
            $carpenter_shop_output .= "$carpenter_shop_indent<ul class='sub-menu'>\n";
        }

        public function start_el(&$carpenter_shop_output, $page, $carpenter_shop_depth = 0, $carpenter_shop_args = array(), $current_page = 0)
        {

            if (isset($carpenter_shop_args['item_spacing']) && 'preserve' === $carpenter_shop_args['item_spacing']) {
                $t = "\t";
                $n = "\n";
            } else {
                $t = '';
                $n = '';
            }
            if ($carpenter_shop_depth) {
                $carpenter_shop_indent = str_repeat($t, $carpenter_shop_depth);
            } else {
                $carpenter_shop_indent = '';
            }

            $carpenter_shop_css_class = array('page_item', 'page-item-' . $page->ID);

            if (isset($carpenter_shop_args['pages_with_children'][$page->ID])) {
                $carpenter_shop_css_class[] = 'page_item_has_children';
            }

            if (!empty($current_page)) {
                $_current_page = get_post($current_page);
                if ($_current_page && in_array($page->ID, $_current_page->ancestors, true)) {
                    $carpenter_shop_css_class[] = 'current_page_ancestor';
                }
                if ($page->ID === $current_page) {
                    $carpenter_shop_css_class[] = 'current_page_item';
                } elseif ($_current_page && $page->ID === $_current_page->post_parent) {
                    $carpenter_shop_css_class[] = 'current_page_parent';
                }
            } elseif (get_option('page_for_posts') === $page->ID) {
                $carpenter_shop_css_class[] = 'current_page_parent';
            }

            /** This filter is documented in wp-includes/class-walker-page.php */
            $carpenter_shop_css_classes = implode(' ', apply_filters('page_css_class', $carpenter_shop_css_class, $page, $carpenter_shop_depth, $carpenter_shop_args, $current_page));
            $carpenter_shop_css_classes = $carpenter_shop_css_classes ? ' class="' . esc_attr($carpenter_shop_css_classes) . '"' : '';

            if ('' === $page->post_title) {
                /* translators: %d: ID of a post. */
                $page->post_title = sprintf(__('#%d (no title)', 'carpenter-shop'), $page->ID);
            }

            $carpenter_shop_args['link_before'] = empty($carpenter_shop_args['link_before']) ? '' : $carpenter_shop_args['link_before'];
            $carpenter_shop_args['link_after'] = empty($carpenter_shop_args['link_after']) ? '' : $carpenter_shop_args['link_after'];

            $carpenter_shop_atts = array();
            $carpenter_shop_atts['href'] = get_permalink($page->ID);
            $carpenter_shop_atts['aria-current'] = ($page->ID === $current_page) ? 'page' : '';

            /** This filter is documented in wp-includes/class-walker-page.php */
            $carpenter_shop_atts = apply_filters('page_menu_link_attributes', $carpenter_shop_atts, $page, $carpenter_shop_depth, $carpenter_shop_args, $current_page);

            $carpenter_shop_attributes = '';
            foreach ($carpenter_shop_atts as $attr => $carpenter_shop_value) {
                if (!empty($carpenter_shop_value)) {
                    $carpenter_shop_value = ('href' === $attr) ? esc_url($carpenter_shop_value) : esc_attr($carpenter_shop_value);
                    $carpenter_shop_attributes .= ' ' . $attr . '="' . $carpenter_shop_value . '"';
                }
            }

            $carpenter_shop_args['list_item_before'] = '';
            $carpenter_shop_args['list_item_after'] = '';
            $carpenter_shop_args['icon_rennder'] = '';
            // Wrap the link in a div and append a sub menu toggle.
            if (isset($carpenter_shop_args['show_toggles']) && true === $carpenter_shop_args['show_toggles']) {
                // Wrap the menu item link contents in a div, used for positioning.
                $carpenter_shop_args['list_item_after'] = '';
            }


            // Add icons to menu items with children.
            if (isset($carpenter_shop_args['show_sub_menu_icons']) && true === $carpenter_shop_args['show_sub_menu_icons']) {
                if (isset($carpenter_shop_args['pages_with_children'][$page->ID])) {
                    $carpenter_shop_args['icon_rennder'] = '';
                }
            }

            // Add icons to menu items with children.
            if (isset($carpenter_shop_args['show_toggles']) && true === $carpenter_shop_args['show_toggles']) {
                if (isset($carpenter_shop_args['pages_with_children'][$page->ID])) {

                    $toggle_target_string = '.page_item.page-item-' . $page->ID . ' > .sub-menu';

                    $carpenter_shop_args['list_item_after'] = '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . __( 'Show sub menu', 'carpenter-shop' ) . '</span>' . carpenter_shop_get_theme_svg( 'chevron-down' ) . '</span></button>';
                }
            }

            if (isset($carpenter_shop_args['show_toggles']) && true === $carpenter_shop_args['show_toggles']) {

                $carpenter_shop_output .= $carpenter_shop_indent . sprintf(
                        '<li%s>%s%s<a%s>%s%s%s</a>%s%s',
                        $carpenter_shop_css_classes,
                        '<div class="submenu-wrapper">',
                        $carpenter_shop_args['list_item_before'],
                        $carpenter_shop_attributes,
                        $carpenter_shop_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $carpenter_shop_args['link_after'],
                        $carpenter_shop_args['list_item_after'],
                        '</div>'
                    );

            }else{

                $carpenter_shop_output .= $carpenter_shop_indent . sprintf(
                        '<li%s>%s<a%s>%s%s%s%s</a>%s',
                        $carpenter_shop_css_classes,
                        $carpenter_shop_args['list_item_before'],
                        $carpenter_shop_attributes,
                        $carpenter_shop_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $carpenter_shop_args['icon_rennder'],
                        $carpenter_shop_args['link_after'],
                        $carpenter_shop_args['list_item_after']
                    );

            }

            if (!empty($carpenter_shop_args['show_date'])) {
                if ('modified' === $carpenter_shop_args['show_date']) {
                    $carpenter_shop_time = $page->post_modified;
                } else {
                    $carpenter_shop_time = $page->post_date;
                }

                $carpenter_shop_date_format = empty($carpenter_shop_args['date_format']) ? '' : $carpenter_shop_args['date_format'];
                $carpenter_shop_output .= ' ' . mysql2date($carpenter_shop_date_format, $carpenter_shop_time);
            }
        }
    }
}