<?php
/**
 * Body Classes.
 * @package Carpenter Shop
 */

if (!function_exists('carpenter_shop_body_classes')) :

    function carpenter_shop_body_classes($carpenter_shop_classes)
    {
        $carpenter_shop_defaults = carpenter_shop_get_default_theme_options();
        $carpenter_shop_layout = carpenter_shop_get_final_sidebar_layout();

        // Adds a class of hfeed to non-singular pages.
        if (!is_singular()) {
            $carpenter_shop_classes[] = 'hfeed';
        }

        // Sidebar layout logic
        $carpenter_shop_classes[] = $carpenter_shop_layout;

        // Copyright alignment
        $copyright_alignment = get_theme_mod('carpenter_shop_copyright_alignment', 'Default');
        $carpenter_shop_classes[] = 'copyright-' . strtolower($copyright_alignment);

        return $carpenter_shop_classes;
    }

endif;

add_filter('body_class', 'carpenter_shop_body_classes');