<?php

/**
 * Title: Why Choose Us
 * Slug: car-dealer-show/why
 * Categories: car-dealer-show/about
 */
$theme_directory = get_template_directory_uri();
?>
<!-- wp:group {"style":{"spacing":{"padding":{"top":"80px","bottom":"80px","left":"40px","right":"40px"}}},"backgroundColor":"base-2","className":"has-soft-background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-soft-background has-background has-dynamic-gradient has-base-2-background-color" style="padding-top:80px;padding-bottom:80px;padding-left:40px;padding-right:40px">
    <!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"42px","fontWeight":"700","lineHeight":"1.1"},"spacing":{"margin":{"bottom":"60px"}}}} -->
    <h2 class="wp-block-heading has-text-align-center" style="font-size:42px;font-weight:700;line-height:1.1;margin-bottom:60px">WHY CHOOSE US</h2>
    <!-- /wp:heading -->
    <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":"60px","margin":{"bottom":"60px"}}}} -->
    <div class="wp-block-columns alignwide" style="margin-bottom:60px">
        <!-- wp:column {"width":"50%","style":{"spacing":{"blockGap":"30px"}}} -->
        <div class="wp-block-column" style="flex-basis:50%">
            <!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"flex","orientation":"vertical"}} -->
            <div class="wp-block-group">
                <!-- wp:paragraph {"style":{"typography":{"fontSize":"20px"}}} -->
                <p style="font-size:20px"><strong>EASY FINANCING OPTIONS</strong></p>
                <!-- /wp:paragraph -->
                <!-- wp:paragraph {"style":{"typography":{"fontSize":"18px"}}} -->
                <p style="font-size:18px">Our hassle-free finance department is dedicated to finding financial solutions that save you money.</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
            <!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"flex","orientation":"vertical"}} -->
            <div class="wp-block-group">
                <!-- wp:paragraph {"style":{"typography":{"fontSize":"20px"}}} -->
                <p style="font-size:20px"><strong>DIVERSE SELECTION OF BRANDS</strong></p>
                <!-- /wp:paragraph -->
                <!-- wp:paragraph {"style":{"typography":{"fontSize":"18px"}}} -->
                <p style="font-size:18px">We offer a wide variety of popular vehicles, including top models from BMW and Ford.</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->
        <!-- wp:column {"width":"50%"} -->
        <div class="wp-block-column" style="flex-basis:50%">
            <!-- wp:image {"sizeSlug":"large","linkDestination":"none","className":"is-style-rounded"} -->
            <figure class="wp-block-image size-large is-style-rounded">
                <img src="<?php echo esc_url($theme_directory) . '/assets/images/car-30984_1280-1024x512.png'; ?>" alt="Car selection showcase" />
            </figure>
            <!-- /wp:image -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
    <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":"60px"}}} -->
    <div class="wp-block-columns alignwide">
        <!-- wp:column {"width":"50%"} -->
        <div class="wp-block-column" style="flex-basis:50%">
            <!-- wp:image {"sizeSlug":"large","linkDestination":"none","className":"is-style-rounded"} -->
            <figure class="wp-block-image size-large is-style-rounded">
                <img src="<?php echo esc_url($theme_directory) . '/assets/images/car-158239_1280-1024x512.png'; ?>" alt="Trusted car dealership" />
            </figure>
            <!-- /wp:image -->
        </div>
        <!-- /wp:column -->
        <!-- wp:column {"width":"50%","style":{"spacing":{"blockGap":"30px"}}} -->
        <div class="wp-block-column" style="flex-basis:50%">
            <!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"flex","orientation":"vertical"}} -->
            <div class="wp-block-group">
                <!-- wp:paragraph {"style":{"typography":{"fontSize":"20px"}}} -->
                <p style="font-size:20px"><strong>TRUSTED BY THOUSANDS</strong></p>
                <!-- /wp:paragraph -->
                <!-- wp:paragraph {"style":{"typography":{"fontSize":"18px"}}} -->
                <p style="font-size:18px">With 10 new deals available daily and 350 offers on our site, we are a trusted choice for a community of thousands.</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
            <!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"flex","orientation":"vertical"}} -->
            <div class="wp-block-group">
                <!-- wp:paragraph {"style":{"typography":{"fontSize":"20px"}}} -->
                <p style="font-size:20px"><strong>AUTO SERVICE & MAINTENANCE</strong></p>
                <!-- /wp:paragraph -->
                <!-- wp:paragraph {"style":{"typography":{"fontSize":"18px"}}} -->
                <p style="font-size:18px">Our service department ensures your vehicle is well-maintained to keep you safe on the road for many more years to come.</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->