<?php

/**
 * Title: Default Header
 * Slug: car-dealer-show/header-default
 * Categories: car-dealer-show/page
 * Block Types: core/template-part/header
 * Keywords: header, top bar, navigation
 */

// Obter o URI do diretório do tema para construir os caminhos das imagens
$theme_assets_uri = get_template_directory_uri() . '/assets/images/';

// Defina os caminhos para as suas imagens
$icon_location_url = esc_url($theme_assets_uri . "icon-location.png");
$icon_envelope_url = esc_url($theme_assets_uri . "icon-envelope.png");
$icon_phone_url    = esc_url($theme_assets_uri . "icon-phone.png");
$icon_clock_url    = esc_url($theme_assets_uri . "icon-clock.png");
?>

<!-- wp:group {"tagName":"header","align":"full","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<header class="wp-block-group alignfull"><!-- wp:group {"align":"full","className":"car-top-bar","style":{"spacing":{"padding":{"top":"10px","bottom":"10px"}}},"layout":{"type":"flex","justifyContent":"space-between","verticalAlignment":"center"}} -->
    <div class="wp-block-group alignfull car-top-bar" style="padding-top:10px;padding-bottom:10px"><!-- wp:group {"className":"top-bar-contact-info","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"left"}} -->
        <div class="wp-block-group top-bar-contact-info"><!-- wp:group {"className":"contact-item","layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"center"}} -->
            <div class="wp-block-group contact-item"><!-- wp:image {"width":"20px","height":"20px","sizeSlug":"full","className":"contact-icon"} -->
                <figure class="wp-block-image size-full is-resized contact-icon"><img src="<?php echo $icon_location_url; ?>" alt="Location" style="width:20px;height:20px" /></figure>
                <!-- /wp:image -->

                <!-- wp:paragraph {"className":"has-base-color has-text-color","fontSize":"small"} -->
                <p class="has-base-color has-text-color has-small-font-size">Miami, Florida</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"className":"contact-item","layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"center"}} -->
            <div class="wp-block-group contact-item"><!-- wp:image {"width":"20px","height":"20px","sizeSlug":"full","className":"contact-icon"} -->
                <figure class="wp-block-image size-full is-resized contact-icon"><img src="<?php echo $icon_envelope_url; ?>" alt="Email" style="width:20px;height:20px" /></figure>
                <!-- /wp:image -->

                <!-- wp:paragraph {"className":"has-base-color has-text-color","fontSize":"small"} -->
                <p class="has-base-color has-text-color has-small-font-size">info@site.com</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"className":"contact-item","layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"center"}} -->
            <div class="wp-block-group contact-item"><!-- wp:image {"width":"20px","height":"20px","sizeSlug":"full","className":"contact-icon"} -->
                <figure class="wp-block-image size-full is-resized contact-icon"><img src="<?php echo $icon_phone_url; ?>" alt="Phone" style="width:20px;height:20px" /></figure>
                <!-- /wp:image -->

                <!-- wp:paragraph {"className":"has-base-color has-text-color","fontSize":"small"} -->
                <p class="has-base-color has-text-color has-small-font-size">987-065-40321</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"className":"contact-item","layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"center"}} -->
            <div class="wp-block-group contact-item"><!-- wp:image {"width":"20px","height":"20px","sizeSlug":"full","className":"contact-icon"} -->
                <figure class="wp-block-image size-full is-resized contact-icon"><img src="<?php echo $icon_clock_url; ?>" alt="Hours" style="width:20px;height:20px" /></figure>
                <!-- /wp:image -->

                <!-- wp:paragraph {"className":"has-base-color has-text-color","fontSize":"small"} -->
                <p class="has-base-color has-text-color has-small-font-size">10 AM – 5 PM</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:group -->

        <!-- wp:social-links {"iconColor":"base","iconColorValue":"#FFFFFF","size":"has-small-icon-size","className":"is-style-logos-only"} -->
        <ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only"><!-- wp:social-link {"url":"#","service":"facebook"} /-->

            <!-- wp:social-link {"url":"#","service":"twitter"} /-->

            <!-- wp:social-link {"url":"#","service":"youtube"} /-->

            <!-- wp:social-link {"url":"#","service":"instagram"} /-->
        </ul>
        <!-- /wp:social-links -->
    </div>
    <!-- /wp:group -->

    <!-- wp:group {"align":"full"} -->
    <div class="wp-block-group alignfull"><!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":"0"}}} -->
        <div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"width":"30%"} -->
            <div class="wp-block-column" style="flex-basis:30%"><!-- wp:group {"className":"car-container-logo","layout":{"type":"constrained"}} -->
                <div class="wp-block-group car-container-logo"><!-- wp:site-logo {"width":200,"shouldSyncIcon":false} /--></div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:column -->

            <!-- wp:column {"width":"70%"} -->
            <div class="wp-block-column" style="flex-basis:70%"><!-- wp:group {"className":"car-container-menu","layout":{"type":"constrained"}} -->
                <div class="wp-block-group car-container-menu"><!-- wp:navigation {"textColor":"base","layout":{"type":"flex","justifyContent":"right"}} -->
                    <!-- wp:navigation-link {"label":"Home","url":"#","kind":"custom","isTopLevelLink":true} /-->

                    <!-- wp:navigation-link {"label":"Inventory","url":"#","kind":"custom","isTopLevelLink":true} /-->

                    <!-- wp:navigation-link {"label":"About Us","url":"#","kind":"custom","isTopLevelLink":true} /-->

                    <!-- wp:navigation-link {"label":"Contact","url":"#","kind":"custom","isTopLevelLink":true} /-->
                    <!-- /wp:navigation -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:column -->
        </div>
        <!-- /wp:columns -->
    </div>
    <!-- /wp:group -->
</header>
<!-- /wp:group -->