<?php

/**
 * Title: FAQ Section
 * Slug: car-dealer-show/faq
 * Categories: car-dealer-show/faq
 */
$theme_directory = get_template_directory_uri();
?>
<!-- wp:group {"style":{"spacing":{"padding":{"top":"80px","bottom":"80px","left":"40px","right":"40px"}}},"backgroundColor":"base-2","className":"has-soft-background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-soft-background has-background has-dynamic-gradient has-base-2-background-color" style="padding-top:80px;padding-bottom:80px;padding-left:40px;padding-right:40px">
    <!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"60px"}}}} -->
    <h2 class="wp-block-heading has-text-align-center" style="margin-bottom:60px">Frequently Asked Questions</h2>
    <!-- /wp:heading -->
    <!-- wp:media-text {"mediaType":"image","mediaWidth":40,"verticalAlignment":"center","style":{"spacing":{"margin":{"bottom":"0"}}}} -->
    <div class="wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center" style="grid-template-columns:40% auto;margin-bottom:0">
        <figure class="wp-block-media-text__media">
            <img src="<?php echo esc_url($theme_directory) . '/assets/images/ai-generated-7703434_1280-1024x682.jpg'; ?>" alt="Car dealership FAQ" />
        </figure>
        <div class="wp-block-media-text__content">
            <!-- wp:details {"style":{"spacing":{"margin":{"bottom":"20px"}}}} -->
            <details class="wp-block-details" style="margin-bottom:20px">
                <summary>How can I book a test drive?</summary>
                <!-- wp:paragraph -->
                <p>You can book a test drive through our website by filling out the test drive request form or by calling us directly. Our team will get in touch to confirm the date and time.</p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
            <!-- wp:details {"style":{"spacing":{"margin":{"bottom":"20px"}}}} -->
            <details class="wp-block-details" style="margin-bottom:20px">
                <summary>What documents are required to purchase a vehicle?</summary>
                <!-- wp:paragraph -->
                <p>To purchase a vehicle, you'll need a valid driver's license, proof of insurance, and financing documents if applicable.</p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
            <!-- wp:details {"style":{"spacing":{"margin":{"bottom":"20px"}}}} -->
            <details class="wp-block-details" style="margin-bottom:20px">
                <summary>Do you offer financing options?</summary>
                <!-- wp:paragraph -->
                <p>Yes, we offer a range of financing options to suit your needs. Our finance team can help you find a plan that works best for you.</p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
            <!-- wp:details {"style":{"spacing":{"margin":{"bottom":"20px"}}}} -->
            <details class="wp-block-details" style="margin-bottom:20px">
                <summary>What is your return policy?</summary>
                <!-- wp:paragraph -->
                <p>We offer a 7-day money-back guarantee on all vehicles. Certain conditions may apply.</p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
            <!-- wp:details -->
            <details class="wp-block-details">
                <summary>Do you provide vehicle maintenance services?</summary>
                <!-- wp:paragraph -->
                <p>Yes, we have a full-service maintenance department with certified technicians to keep your vehicle in optimal condition.</p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
        </div>
    </div>
    <!-- /wp:media-text -->
</div>
<!-- /wp:group -->