<?php

/**
 * Title: Buy and Sell Deals
 * Slug: car-dealer-show/deals
 * Categories: car-dealer-show/services
 * // nov 25
 */
$theme_directory = get_template_directory_uri();
?>

<!-- wp:group {"className":"has-soft-background has-background has-dynamic-gradient has-base-2-background-color","style":{"spacing":{"padding":{"top":"80px","bottom":"80px","left":"40px","right":"40px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-soft-background has-background has-dynamic-gradient has-base-2-background-color" style="padding-top:80px;padding-bottom:80px;padding-left:40px;padding-right:40px">

    <!-- wp:columns {"style":{"spacing":{"blockGap":"40px"}}} -->
    <div class="wp-block-columns">

        <!-- wp:column {"style":{"color":{"background":"#fff5ba"},"spacing":{"padding":{"top":"30px","bottom":"30px","left":"30px","right":"30px"}}}} -->
        <div class="wp-block-column has-background" style="background-color:#fff5ba;padding-top:30px;padding-bottom:30px;padding-left:30px;padding-right:30px">

            <!-- wp:columns {"style":{"spacing":{"blockGap":"20px"}}} -->
            <div class="wp-block-columns">

                <!-- wp:column {"width":"30%"} -->
                <div class="wp-block-column" style="flex-basis:30%">

                    <!-- wp:image {"width":"80px","height":"80px","linkDestination":"none"} -->
                    <figure class="wp-block-image is-resized size-full">
                        <img src="<?php echo esc_url($theme_directory) . '/assets/images/hand_13320273.png'; ?>" alt="Buy car icon" style="width:80px;height:80px" />
                    </figure>
                    <!-- /wp:image -->

                </div>
                <!-- /wp:column -->

                <!-- wp:column {"width":"70%"} -->
                <div class="wp-block-column" style="flex-basis:70%">

                    <!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"bottom":"20px"}}},"fontSize":"large"} -->
                    <p class="has-text-align-center has-large-font-size" style="margin-bottom:20px"><strong>Buy Your Car</strong></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"align":"center","fontSize":"medium"} -->
                    <p class="has-text-align-center has-medium-font-size">Enjoy quality, transparency, and top-notch service when buying your car with us.</p>
                    <!-- /wp:paragraph -->

                </div>
                <!-- /wp:column -->

            </div>
            <!-- /wp:columns -->

        </div>
        <!-- /wp:column -->

        <!-- wp:column {"style":{"color":{"background":"#b1d6f3"},"spacing":{"padding":{"top":"40px","bottom":"40px","left":"30px","right":"30px"}}}} -->
        <div class="wp-block-column has-background" style="background-color:#b1d6f3;padding-top:40px;padding-bottom:40px;padding-left:30px;padding-right:30px">

            <!-- wp:columns {"style":{"spacing":{"blockGap":"20px"}}} -->
            <div class="wp-block-columns">

                <!-- wp:column {"width":"30%"} -->
                <div class="wp-block-column" style="flex-basis:30%">

                    <!-- wp:image {"width":"80px","height":"80px","linkDestination":"none"} -->
                    <figure class="wp-block-image is-resized size-full">
                        <img src="<?php echo esc_url($theme_directory) . '/assets/images/hand_2.png'; ?>" alt="Sell car icon" style="width:80px;height:80px" />
                    </figure>
                    <!-- /wp:image -->

                </div>
                <!-- /wp:column -->

                <!-- wp:column {"width":"70%"} -->
                <div class="wp-block-column" style="flex-basis:70%">

                    <!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"bottom":"20px"}}},"fontSize":"large"} -->
                    <p class="has-text-align-center has-large-font-size" style="margin-bottom:20px"><strong>Sell Your Car</strong></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"align":"center","fontSize":"medium"} -->
                    <p class="has-text-align-center has-medium-font-size">Sell your car with ease, trust, and a fair offer from us.</p>
                    <!-- /wp:paragraph -->

                </div>
                <!-- /wp:column -->

            </div>
            <!-- /wp:columns -->

        </div>
        <!-- /wp:column -->

    </div>
    <!-- /wp:columns -->

</div>
<!-- /wp:group -->