<?php

/**
 * Title: About Us Section
 * Slug: car-dealer-show/about
 * Categories: car-dealer-show/about
 */
$theme_directory = get_template_directory_uri();
?>
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}}},"backgroundColor":"base-2","className":"has-soft-background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-soft-background has-dynamic-gradient has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50)">
    <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|40"}}}} -->
    <div class="wp-block-columns alignwide"><!-- wp:column {"width":"45%"} -->
        <div class="wp-block-column" style="flex-basis:45%"><!-- wp:image {"aspectRatio":"3/4","scale":"cover","sizeSlug":"large","linkDestination":"none"} -->
            <figure class="wp-block-image size-large">
                <img src="<?php echo esc_url($theme_directory) . '/assets/images/dealer.jpg'; ?>" alt="Our dealer" />
            </figure>
            <!-- /wp:image -->
        </div>
        <!-- /wp:column -->
        <!-- wp:column {"width":"55%","style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"flex","orientation":"vertical"}} -->
        <div class="wp-block-column" style="flex-basis:55%"><!-- wp:heading -->
            <h2 class="wp-block-heading">About Us</h2>
            <!-- /wp:heading -->
            <!-- wp:paragraph -->
            <p>We are a trusted car dealer, committed to offering quality vehicles and exceptional customer service to help you find the perfect car.</p>
            <!-- /wp:paragraph -->
            <!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"flex","orientation":"vertical"}} -->
            <div class="wp-block-group">
                <!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} -->
                <div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"width":"32px"} -->
                    <div class="wp-block-column" style="flex-basis:32px">
                        <!-- wp:image {"aspectRatio":"3/4","scale":"cover","sizeSlug":"large","linkDestination":"none"} -->
                        <figure class="wp-block-image size-large">
                            <img src="<?php echo esc_url($theme_directory) . '/assets/images/icon-phone.png'; ?>" alt="Phone Icon" />
                        </figure>
                        <!-- /wp:image -->
                    </div>
                    <!-- /wp:column -->
                    <!-- wp:column -->
                    <div class="wp-block-column"><!-- wp:paragraph -->
                        <p><strong>Phone:</strong> 999-99-111</p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
                <!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} -->
                <div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"width":"32px"} -->
                    <div class="wp-block-column" style="flex-basis:32px">
                        <!-- wp:image {"aspectRatio":"3/4","scale":"cover","sizeSlug":"large","linkDestination":"none"} -->
                        <figure class="wp-block-image size-large">
                            <img src="<?php echo esc_url($theme_directory) . '/assets/images/icon-clock.png'; ?>" alt="Clock Icon" />
                        </figure>
                        <!-- /wp:image -->
                    </div>
                    <!-- /wp:column -->
                    <!-- wp:column -->
                    <div class="wp-block-column"><!-- wp:paragraph -->
                        <p><strong>Hours:</strong> 10 AM – 5 PM</p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
                <!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} -->
                <div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"width":"32px"} -->
                    <div class="wp-block-column" style="flex-basis:32px">
                        <!-- wp:image {"aspectRatio":"3/4","scale":"cover","sizeSlug":"large","linkDestination":"none"} -->
                        <figure class="wp-block-image size-large">
                            <img src="<?php echo esc_url($theme_directory) . '/assets/images/icon-location.png'; ?>" alt="Location Icon" />
                        </figure>
                        <!-- /wp:image -->
                    </div>
                    <!-- /wp:column -->
                    <!-- wp:column -->
                    <div class="wp-block-column"><!-- wp:paragraph -->
                        <p><strong>Location:</strong> 2323 NW Street One, Miami, Florida</p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
                <!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} -->
                <div class="wp-block-columns are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"width":"32px"} -->
                    <div class="wp-block-column" style="flex-basis:32px">
                        <!-- wp:image {"aspectRatio":"3/4","scale":"cover","sizeSlug":"large","linkDestination":"none"} -->
                        <figure class="wp-block-image size-large">
                            <img src="<?php echo esc_url($theme_directory) . '/assets/images/icon-envelope.png'; ?>" alt="Envelope Icon" />
                        </figure>
                        <!-- /wp:image -->
                    </div>
                    <!-- /wp:column -->
                    <!-- wp:column -->
                    <div class="wp-block-column"><!-- wp:paragraph -->
                        <p><strong>Email:</strong> info@site.com</p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->