<?php

/**
 * @package Car-Dealer-Show
 * @since Car-Dealer-Show 1.0
 */

/**
 * Register Theme Dashboard.
 *
 * WARNING: This type of admin page is not allowed in themes on WordPress.org.
 * It must be removed for the theme to be approved.
 */

if (!defined('ABSPATH')) {
    exit;
}

function car_dealer_show_menu()
{
    add_theme_page(
        esc_attr__('Car Dealer Show', 'car-dealer-show'),
        esc_attr__('Car Dealer Theme Dashboard', 'car-dealer-show'),
        'edit_theme_options',
        'car_dealer_show',
        'car_dealer_show_dashboard'
    );
}
add_action('admin_menu', 'car_dealer_show_menu');

function car_dealer_show_admin_theme_style()
{
    $page_value = isset($_GET['page']) ? sanitize_text_field($_GET['page']) : '';
    if ($page_value === 'car_dealer_show') {
        wp_enqueue_style(
            'car_dealer_show_admin_styles',
            esc_url(get_template_directory_uri()) . '/assets/css/admin-styles.css',
            array(),
            wp_get_theme()->get('Version')
        );
    }
}
add_action('admin_enqueue_scripts', 'car_dealer_show_admin_theme_style');

function car_dealer_show_dashboard()
{
?>
    <div id="car-dealer-show-logo">
        <img alt="<?php esc_attr_e('Car Dealer Show Logo', 'car-dealer-show'); ?>" width="300" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/logo-dashboard.png" />
    </div>

    <!-- BEGINNER FRIENDLY WARNING -->
    <div id="car-dealer-show-warning" style="
        background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
        border: 2px solid #ffc107;
        border-radius: 10px;
        padding: 20px;
        margin: 20px 0;
        text-align: center;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    ">
        <div style="
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            margin-bottom: 10px;
        ">
            <span style="
                background: #ffc107;
                color: #856404;
                border-radius: 50%;
                width: 40px;
                height: 40px;
                display: flex;
                align-items: center;
                justify-content: center;
                font-weight: bold;
                font-size: 20px;
            ">!</span>
            <h3 style="
                color: #856404;
                margin: 0;
                font-size: 18px;
            "><?php esc_html_e('Important Notice for Beginners', 'car-dealer-show'); ?></h3>
        </div>
        <p style="
            color: #856404;
            font-size: 14px;
            line-height: 1.5;
            margin: 0;
        ">
            <?php esc_html_e('If you are not experienced with editing block themes, try our free classic theme:', 'car-dealer-show'); ?>
            <br>
            <a href="https://KarDealerTheme.com" target="_blank" style="
                color: #004085;
                font-weight: bold;
                text-decoration: none;
                background: #cce5ff;
                padding: 5px 15px;
                border-radius: 20px;
                display: inline-block;
                margin-top: 8px;
                border: 1px solid #b8daff;
                transition: all 0.3s ease;
            " onmouseover="this.style.background='#b8daff'" onmouseout="this.style.background='#cce5ff'">
                KarDealerTheme.com
            </a>
        </p>
    </div>

    <div id="car-dealer-show-steps3">
        <div class="car-dealer-show-block-title">
            <img alt="<?php esc_attr_e('3 Steps Icon', 'car-dealer-show'); ?>" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/3steps.png" />
            <br /><br />
            <?php esc_attr_e('Follow these 3 steps after installing the theme:', 'car-dealer-show'); ?>
        </div>
        <div class="car-dealer-show-help-container1">
            <div class="car-dealer-show-help-column car-dealer-show-help-column-1">
                <img alt="<?php esc_attr_e('Step 1 Icon', 'car-dealer-show'); ?>" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/step1.png" />
                <h3><?php esc_html_e('Install Plugin', 'car-dealer-show'); ?></h3>
                <?php esc_attr_e('After activating the theme, install the optional free CarDealer plugin.', 'car-dealer-show'); ?>
                <br />
                <?php esc_attr_e('The plugin gives dealers full control over their inventory and content, allowing them to easily manage and sell vehicles online. It provides unlimited options for custom car fields and advanced search filters, helping them perfectly match their listings to their inventory needs.', 'car-dealer-show'); ?>
                <br /><br />
                <?php echo esc_url('https://wordpress.org/plugins/cardealer'); ?>
                <br />
            </div>
            <div class="car-dealer-show-help-column car-dealer-show-help-column-2">
                <img alt="<?php esc_attr_e('Step 2 Icon', 'car-dealer-show'); ?>" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/step2.png" />
                <h3><?php esc_html_e('Install Demo Data (optional)', 'car-dealer-show'); ?></h3>
                <?php esc_attr_e('To get the same look and feel of the demo site, install the demo data (only if you have a blank website now).', 'car-dealer-show'); ?>
                <br />
                <?php esc_attr_e('You can also download the free images used in our demo to add to your pages.', 'car-dealer-show'); ?>
                <br /><br />
                <?php echo esc_url('https://cardealerthemes.com/documentation/'); ?>
                <br />
            </div>
            <div class="car-dealer-show-help-column car-dealer-show-help-column-3">
                <img alt="<?php esc_attr_e('Step 3 Icon', 'car-dealer-show'); ?>" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/step3.png" />
                <h3><?php esc_html_e('Theme Management', 'car-dealer-show'); ?></h3>
                <?php esc_attr_e('To manage the theme, click Appearance => Editor in the left menu.', 'car-dealer-show'); ?>
            </div>
        </div>
    </div>

    <div id="car-dealer-show-services3">
        <div class="car-dealer-show-block-title">
            <?php esc_attr_e('Help, Support, Troubleshooting:', 'car-dealer-show'); ?>
        </div>
        <div class="car-dealer-show-help-container1">
            <div class="car-dealer-show-help-column car-dealer-show-help-column-1">
                <img alt="<?php esc_attr_e('Support Icon', 'car-dealer-show'); ?>" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/support.png" />
                <h3><?php esc_html_e('Help and More Tips', 'car-dealer-show'); ?></h3>
                <?php esc_attr_e('Visit the theme site for more information.', 'car-dealer-show'); ?>
                <br /><br />
            </div>
            <div class="car-dealer-show-help-column car-dealer-show-help-column-2">
                <img alt="<?php esc_attr_e('Service Configuration Icon', 'car-dealer-show'); ?>" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/service_configuration.png" />
                <h3><?php esc_html_e('Online Guide, Support, Demo Video...', 'car-dealer-show'); ?></h3>
                <?php esc_attr_e('You will find our complete and updated online guide, demo video, link to support page, and more useful stuff on our site.', 'car-dealer-show'); ?>
                <br /><br />
                <?php echo esc_url('http://cardealerthemes.com'); ?>
            </div>
            <div class="car-dealer-show-help-column car-dealer-show-help-column-3">
                <img alt="<?php esc_attr_e('System Health Icon', 'car-dealer-show'); ?>" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/system_health.png" />
                <h3><?php esc_html_e('Troubleshooting Guide', 'car-dealer-show'); ?></h3>
                <?php esc_attr_e('Using an old WordPress version, low memory, a plugin with JavaScript errors, or wrong permalink settings are some possible problems. Read this and discover how to fix them quickly!', 'car-dealer-show'); ?>
                <br /><br />
                <?php echo esc_url('http://siterightaway.net/troubleshooting/'); ?>
            </div>
        </div>
    </div>
<?php
}
