<?php
/**
	 * Popular section
	 */
	// Popular section
	$wp_customize->add_section(
		'capture_blog_popular',
		array(
			'title' => esc_html__( 'Popular Post', 'capture-blog' ),
			'panel' => 'ideal_blog_home_panel',
		)
	);

	// Popular Section enable setting
	$wp_customize->add_setting(
		'capture_blog_popular_section_enable',
		array(
			'sanitize_callback' => 'ideal_blog_sanitize_checkbox',
			'default' => false,
		)
	);

	$wp_customize->add_control(
		'capture_blog_popular_section_enable',
		array(
			'section'		=> 'capture_blog_popular',
			'label'			=> esc_html__( 'Enable Popular Section.', 'capture-blog' ),
			'type'			=> 'checkbox',
		)
	);

	// Popular title setting
	$wp_customize->add_setting(
		'capture_blog_popular_title',
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'capture_blog_popular_title',
		array(
			'section'		=> 'capture_blog_popular',
			'label'			=> esc_html__( 'Title:', 'capture-blog' ),
		)
	);


	// Slider number setting
	$wp_customize->add_setting(
		'capture_blog_popular_secion_excerpt',
		array(
			'sanitize_callback' => 'ideal_blog_sanitize_number_range',
			'default' => 20,
			'transport'	=> 'postMessage',
		)
	);

	// Popular category setting
	$wp_customize->add_setting(
		'capture_blog_popular_cat',
		array(
			'sanitize_callback' => 'ideal_blog_sanitize_select',
		)
	);

	$wp_customize->add_control(
		'capture_blog_popular_cat',
		array(
			'section'		=> 'capture_blog_popular',
			'label'			=> esc_html__( 'Category:', 'capture-blog' ),
			'type'			=> 'select',
			'choices'		=> capture_blog_get_post_cat_choices(),
		)
	);
?>