<?php

if (function_exists('register_sidebar')) register_sidebar();

automatic_feed_links();

add_action ('admin_menu', 'cammino_add_theme_page');
function cammino_add_theme_page () {
	if ( isset( $_GET['page'] ) && $_GET['page'] == basename(__FILE__) ) {
		if (isset($_POST['colors'])) {
			update_option ('cammino-colors',$_POST['colors']);
			update_option ('cammino-mode',$_POST['mode']);
			update_option ('cammino-width-type',$_POST['width-type']);
			update_option ('cammino-header',$_POST['header']);
			if ($_POST['width-type']=="fixed-width")
				update_option ('cammino-width',$_POST['width']);
			else
				delete_option ('cammino-width');
			if ($_POST['header']=='custom') {
				update_option ('cammino-header-image',$_POST['header-image']);
				update_option ('cammino-height',$_POST['height']);
				update_option ('cammino-title',$_POST['title']);
			} else {
				delete_option ('cammino-header-image');
				delete_option ('cammino-height');
				delete_option ('cammino-title');
			}
			if ($_POST['header']=='custom' AND $_POST['title']!='no') {
				update_option ('cammino-title-color',$_POST['title-color']);
				update_option ('cammino-title-position',$_POST['title-position']);
			} else {
				delete_option ('cammino-title-color');
				delete_option ('cammino-title-position');
			}
			if ($_POST['header']=='custom' AND $_POST['width-type']!='fixed-width') {
				update_option ('cammino-position',$_POST['position']);
				update_option ('cammino-bg-type',$_POST['bg-type']);
			} else {
				delete_option ('cammino-position');
				delete_option ('cammino-bg-type');
			}
			if ($_POST['header']=='custom' AND $_POST['width-type']!='fixed-width' AND $_POST['bg-type']!='image')
				update_option ('cammino-bg-color',$_POST['bg-color']);
			else
				delete_option ('cammino-bg-color');
			if ($_POST['header']=='custom' AND $_POST['width-type']!='fixed-width' AND $_POST['bg-type']=='image')
				update_option ('cammino-bg-image',$_POST['bg-image']);
			else
				delete_option ('cammino-bg-image');
		}
		add_action ('admin_head', 'cammino_theme_page_head');
	}
	add_theme_page ('Theme Options', 'Theme Options', 'edit_themes', basename(__FILE__), 'cammino_theme_page');
}
function cammino_theme_page_head () {
	wp_enqueue_script('jquery');
	?>
	<script type="text/javascript">
	/* <![CDATA[ */
	jQuery(document).ready(function($){
	
	function hide () {
		if ($("#cammino-width-type").val()=="fixed-width")
			$("#cammino-width").parent().css("display","block");
		else
			$("#cammino-width").parent().css("display","none");
		if ($("#cammino-header").val()=="custom") {
			$("#cammino-header-image").parent().css("display","block");
			$("#cammino-height").parent().css("display","block");
			$("#cammino-title").parent().css("display","block");
		} else {
			$("#cammino-header-image").parent().css("display","none");
			$("#cammino-height").parent().css("display","none");
			$("#cammino-title").parent().css("display","none");
		}
		if ($("#cammino-header").val()=="custom"&&$("#cammino-title").val()!="no") {
			$("#cammino-title-color").parent().css("display","block");
			$("#cammino-title-position").parent().css("display","block");
		} else {
			$("#cammino-title-color").parent().css("display","none");
			$("#cammino-title-position").parent().css("display","none");
		}
		if ($("#cammino-header").val()=="custom"&&$("#cammino-width-type").val()!="fixed-width") {
			$("#cammino-position").parent().css("display","block");
			$("#cammino-bg-type").parent().css("display","block");
		} else {
			$("#cammino-position").parent().css("display","none");
			$("#cammino-bg-type").parent().css("display","none");
		}
		if ($("#cammino-header").val()=="custom"&&$("#cammino-width-type").val()!="fixed-width"&&$("#cammino-bg-type").val()!="image")
			$("#cammino-bg-color").parent().css("display","block");
		else
			$("#cammino-bg-color").parent().css("display","none");
		if ($("#cammino-header").val()=="custom"&&$("#cammino-width-type").val()!="fixed-width"&&$("#cammino-bg-type").val()=="image")
			$("#cammino-bg-image").parent().css("display","block");
		else
			$("#cammino-bg-image").parent().css("display","none");
	}
	hide();
	$("#cammino-width-type").change(function(){hide();});
	$("#cammino-header").change(function(){hide();});
	$("#cammino-title").change(function(){hide();});
	$("#cammino-bg-type").change(function(){hide();});
	
	});
	/* ]]> */
	</script>
	<?php
}
function cammino_theme_page () {
	?>
	<div class="wrap">
	<h2>Theme Options</h2>
	<form method="post" action="">
	<div>
		<label for="cammino-colors">colours:</label>
		<select name="colors" id="cammino-colors"><option>original</option><option <?php if (get_option('cammino-colors')=='bright') echo 'selected'; ?>>bright</option></select>
	</div>
	<div>
		<label for="cammino-mode">mode (with 'JavaScript' you have the 'short', 'long' and 'comments' buttons):</label>
		<select name="mode" id="cammino-mode"><option value="javascript">JavaScript</option><option <?php if (get_option('cammino-mode')=='traditional') echo 'selected'; ?>>traditional</option></select>
	</div>
	<div><select name="width-type" id="cammino-width-type"><option>flexible-width</option><option <?php if (get_option('cammino-width-type')=='fixed-width') echo 'selected'; ?>>fixed-width</option></select></div>
	<div>
		<label for="cammino-width">width in pixels:</label>
		<input type="text" name="width" id="cammino-width" value="<?php if (get_option('cammino-width')) echo get_option('cammino-width'); else echo '500'; ?>">
	</div>
	<div><select name="header" id="cammino-header"><option value="standard">standard header</option><option value="custom" <?php if (get_option('cammino-header')=='custom') echo 'selected'; ?>>custom header</option></select></div>
	<div>
		<div><label for="cammino-header-image">header image location (a full url with http:// at the beginning):</label></div>
		<input type="text" name="header-image" id="cammino-header-image" value="<?php if (get_option('cammino-header-image')) echo get_option('cammino-header-image'); ?>" size="80">
	</div>
	<div>
		<label for="cammino-height">header height in pixels (height of the image):</label>
		<input type="text" name="height" id="cammino-height" value="<?php if (get_option('cammino-height')) echo get_option('cammino-height'); else echo '200'; ?>">
	</div>
	<div>
		<label for="cammino-title">display blog title and description in header (or is it already in the image):</label>
		<select name="title" id="cammino-title"><option>yes</option><option <?php if (get_option('cammino-title')=='no') echo 'selected'; ?>>no</option></select>
	</div>
	<div>
		<label for="cammino-title-color">title and description colour:</label>
		<select name="title-color" id="cammino-title-color"><option>bright</option><option <?php if (get_option('cammino-title-color')=="dark") echo 'selected'; ?>>dark</option></select>
	</div>
	<div>
		<label for="cammino-title-position">title and description position:</label>
		<select name="title-position" id="cammino-title-position"><option>center</option><option <?php if (get_option('cammino-title-position')=='left') echo 'selected'; ?>>left</option><option <?php if (get_option('cammino-title-position')=='right') echo 'selected'; ?>>right</option></select>
	</div>
	<div>
		<label for="cammino-position">header image position:</label>
		<select name="position" id="cammino-position"><option>center</option><option <?php if (get_option('cammino-position')=='left') echo 'selected'; ?>>left</option><option <?php if (get_option('cammino-position')=='right') echo 'selected'; ?>>right</option></select>
	</div>
	<div>
		<label for="cammino-bg-type">header background type:</label>
		<select name="bg-type" id="cammino-bg-type"><option>color</option><option value="image" <?php if (get_option('cammino-bg-type')=='image') echo 'selected'; ?>>repeated image</option></select>
	</div>
	<div>
		<label for="cammino-bg-color">header background colour (behind the image):</label>
		<input type="text" name="bg-color" id="cammino-bg-color" value="<?php if (get_option('cammino-bg-color')) echo get_option('cammino-bg-color'); else echo '#000000'; ?>">
	</div>
	<div>
		<div><label for="cammino-bg-image">header background image location (repeated image behind the front image):</label></div>
		<input type="text" name="bg-image" id="cammino-bg-image" value="<?php if (get_option('cammino-bg-image')) echo get_option('cammino-bg-image'); ?>" size="80">
	</div>
	<div><input type="submit" value="save settings"></div>
	</form>
	</div>
	<?php
}

add_action('wp_head', 'cammino_head');
function cammino_head () {
	?>
	<style type="text/css">
	<?php if (get_option("cammino-colors")=="bright" AND get_option("cammino-header")!="custom") : ?>
	body { background-color:#BBBBBB; }
	#shadow, #sidebar { background-color:#EEEEEE; }
	#headerbg, #footer { background-color:#6699CC; }
	#header h1, #header a, #header h3, #footer a { color:#EEEEEE; }
	.separator, .type div.active, #navigation a:hover { background-color:#BBBBBB; }
	h2.title, h2.title a, h3.title, #sidebar h2 { color:#6699CC; }
	.date { color:#888888; }
	#handle:hover { background-color:#FFFFFF !important; }
	<?php elseif (get_option("cammino-colors")=="bright" AND get_option("cammino-header")=="custom") : ?>
	body { background-color:#BBBBBB; }
	#shadow, #sidebar { background-color:#EEEEEE; }
	#footer { background-color:#888888; }
	#footer a { color:#EEEEEE; }
	.separator, .type div.active, #navigation a:hover { background-color:#BBBBBB; }
	h2.title, h2.title a, h3.title, #sidebar h2 { color:#333333; }
	.date { color:#888888; }
	#handle:hover { background-color:#FFFFFF !important; }
	<?php elseif (get_option("cammino-colors")!="bright" AND get_option("cammino-header")=="custom") : ?>
	#footer { background-color:#666666; }
	h2.title, h2.title a, h3.title, #sidebar h2 { color:#666666; }
	<?php endif; ?>
	
	<?php if (get_option("cammino-width-type")=="fixed-width") : ?>
	#shadow { width:<?php echo get_option("cammino-width"); ?>px; }
	<?php endif; ?>
	
	<?php if (get_option("cammino-header")=="custom") : ?>
	#header { background:transparent url(<?php echo get_option("cammino-header-image"); ?>) no-repeat; }
	#header, #headerbg { height:<?php echo get_option("cammino-height"); ?>px; background-color:transparent; }
	<?php endif; ?>
	
	<?php if (get_option("cammino-header")=="custom" AND get_option("cammino-title")!="no") : ?>
	<?php $padding = (get_option("cammino-height")-80)/2; ?>
	#header h1 { padding:<?php echo $padding; ?>px <?php echo $padding; ?>px 0 <?php echo $padding; ?>px; }
	#header h3 { padding:0 <?php echo $padding; ?>px <?php echo $padding; ?>px <?php echo $padding; ?>px; }
		<?php if (get_option("cammino-title-color")!="dark" AND get_option("cammino-colors")=="bright") : ?>
		#header h1, #header a, #header h3 { color:#EEEEEE; }
		<?php elseif (get_option("cammino-title-color")!="dark" AND get_option("cammino-colors")!="bright") : ?>
		#header h1, #header a, #header h3 { color:#CCCCCC; }
		<?php else : ?>
		#header h1, #header a, #header h3 { color:#333333; }
		<?php endif; ?>
	#header h1, #header h3 { text-align:<?php echo get_option('cammino-title-position'); ?>; }
	<?php endif; ?>
	
	<?php if (get_option("cammino-header")=="custom" AND get_option("cammino-width-type")!="fixed-width") : ?>
	#header { background-position:<?php echo get_option("cammino-position"); ?>; }
		<?php if (get_option("cammino-bg-type")=="image") : ?>
		#headerbg { background:url(<?php echo get_option("cammino-bg-image"); ?>) repeat; }
		<?php else : ?>
		#headerbg { background-color:<?php echo get_option("cammino-bg-color"); ?>; }
		<?php endif; ?>
	<?php endif; ?>
	</style>
	<?php
}

?>