<?php if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME'])) die; ?>
<?php if ( post_password_required() ) {
	echo '<div class="padding">This post is password protected. Enter the password to view comments.</div>';
	return;
} ?>

<?php if ( have_comments() ) : ?>
	<div class="scroll">
	<?php foreach ($comments as $comment) : ?>
		<?php echo get_avatar($comment,50); ?>
		<div style="min-height:60px">
		<h3 class="title"><?php comment_author(); ?> (<?php comment_time('j F Y g:i A') ?>)</h3>
		<?php comment_text(); ?>
		</div>
	<?php endforeach; ?>
	</div>
<?php else: ?>
	<div class="scroll">There are no comments for this post.</div>
<?php endif; ?>

<div class="padding">
<?php if ( comments_open() ) : ?>
	<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
		<p>You must be <a href="<?php echo wp_login_url( get_permalink() ); ?>">logged in</a> to post a comment.</p>
	<?php else : ?>
		<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
		<?php if ( is_user_logged_in() ) : ?>
			<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Log out &raquo;</a></p>
		<?php else : ?>
			<p><input type="text" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" tabindex="1" style="width:50%" <?php if ($req) echo "aria-required='true'"; ?>>
			<label for="author"><small>Name <?php if ($req) echo "(required)"; ?></small></label></p>
			<p><input type="text" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" tabindex="2" style="width:50%" <?php if ($req) echo "aria-required='true'"; ?>>
			<label for="email"><small>Mail (will not be published) <?php if ($req) echo "(required)"; ?></small></label></p>
			<p><input type="text" name="url" id="url" value="<?php echo esc_attr($comment_author_url); ?>" tabindex="3" style="width:50%">
			<label for="url"><small>Website</small></label></p>
		<?php endif; ?>
		<p><textarea name="comment" id="comment" rows="10" tabindex="4" style="width:100%"></textarea></p>
		<p><input name="submit" type="submit" id="submit" tabindex="5" value="Submit Comment">
		<?php comment_id_fields(); ?>
		</p>
		<?php do_action('comment_form', $post->ID); ?>
		</form>
	<?php endif; ?>
<?php else: ?>
Comments are closed.
<?php endif; ?>
</div>