<?php

if ( ! function_exists( 'camera_store_add_zoom_section' ) ) :

    function camera_store_add_zoom_section() {
        

        if ( get_theme_mod( 'zoom_section_enable' ) == false ) {
            return false;
        }

        $section_details = array();
        $section_details = apply_filters( 'camera_store_filter_zoom_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        camera_store_render_zoom_section( $section_details );
    }
endif;

if ( ! function_exists( 'camera_store_get_zoom_section_details' ) ) :

    function camera_store_get_zoom_section_details( $input ) {

        $content = array();
        $page_id = ! empty( get_theme_mod( 'zoom_content_page' ) ) ? get_theme_mod( 'zoom_content_page' ) : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    ); 

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = stortech_trim_content( 40 );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;

add_filter( 'camera_store_filter_zoom_section_details', 'camera_store_get_zoom_section_details' );


if ( ! function_exists( 'camera_store_render_zoom_section' ) ) :

   function camera_store_render_zoom_section( $content_details = array() ) {
        $options = stortech_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="stortech_zoom_section">
       
        <div id="zoom" class="page-section no-padding-top">
            <div class="wrapper">

                <?php foreach ($content_details as $content ): ?>

                    <article class="has-post-thumbnail">
                        <div class="featured-image" style="background-image:url('<?php echo esc_html( $content['image'] ); ?>')"></div>

                        <div class="entry-container">
                            <div class="section-header">
                                <h2 class="section-title"><?php echo esc_html( $content['title'] ); ?></h2>
                            </div><!-- .section-header -->

                            <div class="entry-content">
                                <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                            </div><!-- .entry-content -->

                            <?php if( !empty( get_theme_mod( 'zoom_btn_label' ) ) ): ?>
                                <div class="read-more">
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn btn-fill" tabindex="0"><?php echo esc_html( get_theme_mod( 'zoom_btn_label' ) ); ?>
                                        <svg viewBox="0 0 443.52 443.52">
                                            <path d="M336.226,209.591l-204.8-204.8c-6.78-6.548-17.584-6.36-24.132,0.42c-6.388,6.614-6.388,17.099,0,23.712l192.734,192.734
                                            L107.294,414.391c-6.663,6.664-6.663,17.468,0,24.132c6.665,6.663,17.468,6.663,24.132,0l204.8-204.8
                                            C342.889,227.058,342.889,216.255,336.226,209.591z"/>
                                        </svg>
                                    </a>    
                                </div><!-- .read-more -->
                            <?php endif; ?>
                        </div>
                    </article>

                <?php endforeach; ?>

            </div><!-- about-us -->
        </div>

        </div>
              
<?php    }
endif;