<?php

if ( ! function_exists( 'camera_store_add_gallery_section' ) ) :

    function camera_store_add_gallery_section() {
        
        if ( get_theme_mod( 'gallery_section_enable' ) == false ) {
            return false;
        }

        $section_details = array();
        $section_details = apply_filters( 'camera_store_filter_gallery_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        camera_store_render_gallery_section( $section_details );
    }
endif;

if ( ! function_exists( 'camera_store_get_gallery_section_details' ) ) :

    function camera_store_get_gallery_section_details( $input ) {
        
        $content = array();

        $post_ids = array();

                for ( $i = 1; $i <= 5; $i++ ) {
                    if ( ! empty( get_theme_mod( 'gallery_content_post_'.$i ) ) )
                        $post_ids[] = get_theme_mod( 'gallery_content_post_'.$i );
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( 5 ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    ); 

            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;

add_filter( 'camera_store_filter_gallery_section_details', 'camera_store_get_gallery_section_details' );


if ( ! function_exists( 'camera_store_render_gallery_section' ) ) :

   function camera_store_render_gallery_section( $content_details = array() ) {

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="stortech_gallery_section">
        
        <div id="camera-masonry" class="relative page-section">
                <div class="wrapper">
                    <div class="grid clear">
                        <article class="grid-item">
                            <?php if( !empty( get_theme_mod( 'gallery_title' ) ) ): ?>
                                <div class="section-header">
                                    <h2 class="section-title"><?php echo esc_html( get_theme_mod( 'gallery_title' ) ); ?></h2>
                                </div>
                            <?php endif;

                            if( !empty( get_theme_mod( 'gallery_subtitle' ) ) ): ?>

                            <div class="section-content">
                                <p><?php echo esc_html( get_theme_mod( 'gallery_subtitle' ) ); ?></p>
                            </div>
                        <?php endif; ?>
                    </article>

                        <?php foreach ($content_details as $content ): ?>
                            
                        <article class="grid-item">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                            </div>
                        </article>

                        <?php endforeach; ?>

                    </div>
                </div>
            </div>

            </div>
             
    <?php }
endif;